/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol.inference;

import aima.core.logic.fol.StandardizeApart;
import aima.core.logic.fol.StandardizeApartIndexical;
import aima.core.logic.fol.StandardizeApartIndexicalFactory;
import aima.core.logic.fol.inference.AbstractModulation;
import aima.core.logic.fol.inference.proof.ProofStepClauseParamodulation;
import aima.core.logic.fol.kb.data.Clause;
import aima.core.logic.fol.kb.data.Literal;
import aima.core.logic.fol.parsing.ast.AtomicSentence;
import aima.core.logic.fol.parsing.ast.Term;
import aima.core.logic.fol.parsing.ast.TermEquality;
import aima.core.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Paramodulation
extends AbstractModulation {
    private static StandardizeApartIndexical _saIndexical = StandardizeApartIndexicalFactory.newStandardizeApartIndexical(Character.valueOf('p'));
    private static List<Literal> _emptyLiteralList = new ArrayList<Literal>();
    private StandardizeApart sApart = new StandardizeApart();

    public Set<Clause> apply(Clause c1, Clause c2) {
        return this.apply(c1, c2, false);
    }

    public Set<Clause> apply(Clause c1, Clause c2, boolean standardizeApart) {
        LinkedHashSet<Clause> paraExpressions = new LinkedHashSet<Clause>();
        for (int i = 0; i < 2; ++i) {
            Clause equalityClause;
            Clause topClause;
            if (i == 0) {
                topClause = c1;
                equalityClause = c2;
            } else {
                topClause = c2;
                equalityClause = c1;
            }
            for (Literal possEqLit : equalityClause.getLiterals()) {
                if (!possEqLit.isPositiveLiteral() || !(possEqLit.getAtomicSentence() instanceof TermEquality)) continue;
                TermEquality assertion = (TermEquality)possEqLit.getAtomicSentence();
                block2: for (int x = 0; x < 2; ++x) {
                    Term toReplaceWith;
                    Term toMatch;
                    if (x == 0) {
                        toMatch = assertion.getTerm1();
                        toReplaceWith = assertion.getTerm2();
                    } else {
                        toMatch = assertion.getTerm2();
                        toReplaceWith = assertion.getTerm1();
                    }
                    for (Literal l1 : topClause.getLiterals()) {
                        AbstractModulation.IdentifyCandidateMatchingTerm icm = this.getMatchingSubstitution(toMatch, l1.getAtomicSentence());
                        if (null == icm) continue;
                        Term replaceWith = this.substVisitor.subst(icm.getMatchingSubstitution(), toReplaceWith);
                        if (icm.getMatchingTerm().equals(replaceWith)) continue;
                        AbstractModulation.ReplaceMatchingTerm rmt = new AbstractModulation.ReplaceMatchingTerm(this);
                        AtomicSentence altExpression = rmt.replace(l1.getAtomicSentence(), icm.getMatchingTerm(), replaceWith);
                        ArrayList<Literal> newLits = new ArrayList<Literal>();
                        for (Literal l2 : topClause.getLiterals()) {
                            if (l1.equals(l2)) {
                                newLits.add(l1.newInstance((AtomicSentence)this.substVisitor.subst(icm.getMatchingSubstitution(), altExpression)));
                                continue;
                            }
                            newLits.add(this.substVisitor.subst(icm.getMatchingSubstitution(), l2));
                        }
                        for (Literal l2 : equalityClause.getLiterals()) {
                            if (possEqLit.equals(l2)) continue;
                            newLits.add(this.substVisitor.subst(icm.getMatchingSubstitution(), l2));
                        }
                        Clause nc = null;
                        if (standardizeApart) {
                            this.sApart.standardizeApart(newLits, _emptyLiteralList, _saIndexical);
                            nc = new Clause(newLits);
                        } else {
                            nc = new Clause(newLits);
                        }
                        nc.setProofStep(new ProofStepClauseParamodulation(nc, topClause, equalityClause, assertion));
                        if (c1.isImmutable()) {
                            nc.setImmutable();
                        }
                        if (!c1.isStandardizedApartCheckRequired()) {
                            c1.setStandardizedApartCheckNotRequired();
                        }
                        paraExpressions.add(nc);
                        continue block2;
                    }
                }
            }
        }
        return paraExpressions;
    }

    @Override
    protected boolean isValidMatch(Term toMatch, Set<Variable> toMatchVariables, Term possibleMatch, Map<Variable, Term> substitution) {
        return possibleMatch != null && substitution != null && !(possibleMatch instanceof Variable);
    }
}

