/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol.inference;

import aima.core.logic.fol.StandardizeApartInPlace;
import aima.core.logic.fol.SubstVisitor;
import aima.core.logic.fol.Unifier;
import aima.core.logic.fol.inference.proof.ProofStepChainReduction;
import aima.core.logic.fol.kb.data.Chain;
import aima.core.logic.fol.kb.data.Literal;
import aima.core.logic.fol.kb.data.ReducedLiteral;
import aima.core.logic.fol.parsing.ast.AtomicSentence;
import aima.core.logic.fol.parsing.ast.Term;
import aima.core.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class IndexedFarParents {
    private int saIdx = 0;
    private Unifier unifier = new Unifier();
    private SubstVisitor substVisitor = new SubstVisitor();
    private Map<String, List<Chain>> posHeads = new LinkedHashMap<String, List<Chain>>();
    private Map<String, List<Chain>> negHeads = new LinkedHashMap<String, List<Chain>>();

    public IndexedFarParents(List<Chain> sos, List<Chain> background) {
        this.constructInternalDataStructures(sos, background);
    }

    public int getNumberFarParents(Chain farParent) {
        String headKey;
        Literal head = farParent.getHead();
        Map<String, List<Chain>> heads = null;
        heads = head.isPositiveLiteral() ? this.posHeads : this.negHeads;
        List<Chain> farParents = heads.get(headKey = head.getAtomicSentence().getSymbolicName());
        if (null != farParents) {
            return farParents.size();
        }
        return 0;
    }

    public void resetNumberFarParentsTo(Chain farParent, int toSize) {
        Literal head = farParent.getHead();
        Map<String, List<Chain>> heads = null;
        heads = head.isPositiveLiteral() ? this.posHeads : this.negHeads;
        String key = head.getAtomicSentence().getSymbolicName();
        List<Chain> farParents = heads.get(key);
        while (farParents.size() > toSize) {
            farParents.remove(farParents.size() - 1);
        }
    }

    public int getNumberCandidateFarParents(Chain nearParent) {
        String nearestKey;
        Literal nearestHead = nearParent.getHead();
        Map<String, List<Chain>> candidateHeads = null;
        candidateHeads = nearestHead.isPositiveLiteral() ? this.negHeads : this.posHeads;
        List<Chain> farParents = candidateHeads.get(nearestKey = nearestHead.getAtomicSentence().getSymbolicName());
        if (null != farParents) {
            return farParents.size();
        }
        return 0;
    }

    public Chain attemptReduction(Chain nearParent, int farParentIndex) {
        AtomicSentence nearAtom;
        String nearestKey;
        Chain nnpc = null;
        Literal nearLiteral = nearParent.getHead();
        Map<String, List<Chain>> candidateHeads = null;
        candidateHeads = nearLiteral.isPositiveLiteral() ? this.negHeads : this.posHeads;
        List<Chain> farParents = candidateHeads.get(nearestKey = (nearAtom = nearLiteral.getAtomicSentence()).getSymbolicName());
        if (null != farParents) {
            Chain farParent = farParents.get(farParentIndex);
            this.standardizeApart(farParent);
            Literal farLiteral = farParent.getHead();
            AtomicSentence farAtom = farLiteral.getAtomicSentence();
            Map<Variable, Term> subst = this.unifier.unify(nearAtom, farAtom);
            if (null != subst) {
                AtomicSentence atom;
                Chain topChain = farParent;
                Literal botLit = nearLiteral;
                Chain botChain = nearParent;
                ArrayList<Literal> reduction = new ArrayList<Literal>();
                for (Literal l : topChain.getTail()) {
                    atom = (AtomicSentence)this.substVisitor.subst(subst, l.getAtomicSentence());
                    reduction.add(l.newInstance(atom));
                }
                reduction.add(new ReducedLiteral((AtomicSentence)this.substVisitor.subst(subst, botLit.getAtomicSentence()), botLit.isNegativeLiteral()));
                for (Literal l : botChain.getTail()) {
                    atom = (AtomicSentence)this.substVisitor.subst(subst, l.getAtomicSentence());
                    reduction.add(l.newInstance(atom));
                }
                nnpc = new Chain(reduction);
                nnpc.setProofStep(new ProofStepChainReduction(nnpc, nearParent, farParent, subst));
            }
        }
        return nnpc;
    }

    public Chain addToIndex(Chain c) {
        Chain added = null;
        Literal head = c.getHead();
        if (null != head) {
            String key;
            Map<String, List<Chain>> toAddTo = null;
            toAddTo = head.isPositiveLiteral() ? this.posHeads : this.negHeads;
            List<Chain> farParents = toAddTo.get(key = head.getAtomicSentence().getSymbolicName());
            if (null == farParents) {
                farParents = new ArrayList<Chain>();
                toAddTo.put(key, farParents);
            }
            added = c;
            farParents.add(added);
        }
        return added;
    }

    public void standardizeApart(Chain c) {
        this.saIdx = StandardizeApartInPlace.standardizeApart(c, this.saIdx);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("#");
        sb.append(this.posHeads.size());
        for (String key : this.posHeads.keySet()) {
            sb.append(",");
            sb.append(this.posHeads.get(key).size());
        }
        sb.append(" posHeads=");
        sb.append(this.posHeads.toString());
        sb.append("\n");
        sb.append("#");
        sb.append(this.negHeads.size());
        for (String key : this.negHeads.keySet()) {
            sb.append(",");
            sb.append(this.negHeads.get(key).size());
        }
        sb.append(" negHeads=");
        sb.append(this.negHeads.toString());
        return sb.toString();
    }

    private void constructInternalDataStructures(List<Chain> sos, List<Chain> background) {
        ArrayList<Chain> toIndex = new ArrayList<Chain>();
        toIndex.addAll(sos);
        toIndex.addAll(background);
        for (Chain c : toIndex) {
            this.addToIndex(c);
        }
    }
}

