/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol.inference;

import aima.core.logic.fol.inference.InferenceProcedure;
import aima.core.logic.fol.inference.InferenceResult;
import aima.core.logic.fol.inference.proof.Proof;
import aima.core.logic.fol.inference.proof.ProofFinal;
import aima.core.logic.fol.inference.proof.ProofStepGoal;
import aima.core.logic.fol.inference.trace.FOLTFMResolutionTracer;
import aima.core.logic.fol.kb.FOLKnowledgeBase;
import aima.core.logic.fol.kb.data.Clause;
import aima.core.logic.fol.kb.data.Literal;
import aima.core.logic.fol.parsing.ast.ConnectedSentence;
import aima.core.logic.fol.parsing.ast.NotSentence;
import aima.core.logic.fol.parsing.ast.Sentence;
import aima.core.logic.fol.parsing.ast.Term;
import aima.core.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class FOLTFMResolution
implements InferenceProcedure {
    private long maxQueryTime = 10000L;
    private FOLTFMResolutionTracer tracer = null;

    public FOLTFMResolution() {
    }

    public FOLTFMResolution(long maxQueryTime) {
        this.setMaxQueryTime(maxQueryTime);
    }

    public FOLTFMResolution(FOLTFMResolutionTracer tracer) {
        this.setTracer(tracer);
    }

    public long getMaxQueryTime() {
        return this.maxQueryTime;
    }

    public void setMaxQueryTime(long maxQueryTime) {
        this.maxQueryTime = maxQueryTime;
    }

    public FOLTFMResolutionTracer getTracer() {
        return this.tracer;
    }

    public void setTracer(FOLTFMResolutionTracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public InferenceResult ask(FOLKnowledgeBase KB, Sentence alpha) {
        LinkedHashSet<Clause> clauses = new LinkedHashSet<Clause>();
        for (Clause c : KB.getAllClauses()) {
            c = KB.standardizeApart(c);
            c.setStandardizedApartCheckNotRequired();
            clauses.addAll(c.getFactors());
        }
        NotSentence notAlpha = new NotSentence(alpha);
        Literal answerLiteral = KB.createAnswerLiteral(notAlpha);
        Set<Variable> answerLiteralVariables = KB.collectAllVariables(answerLiteral.getAtomicSentence());
        Clause answerClause = new Clause();
        if (answerLiteralVariables.size() > 0) {
            ConnectedSentence notAlphaWithAnswer = new ConnectedSentence("OR", notAlpha, answerLiteral.getAtomicSentence());
            for (Clause c : KB.convertToClauses(notAlphaWithAnswer)) {
                c = KB.standardizeApart(c);
                c.setProofStep(new ProofStepGoal(c));
                c.setStandardizedApartCheckNotRequired();
                clauses.addAll(c.getFactors());
            }
            answerClause.addLiteral(answerLiteral);
        } else {
            for (Clause c : KB.convertToClauses(notAlpha)) {
                c = KB.standardizeApart(c);
                c.setProofStep(new ProofStepGoal(c));
                c.setStandardizedApartCheckNotRequired();
                clauses.addAll(c.getFactors());
            }
        }
        TFMAnswerHandler ansHandler = new TFMAnswerHandler(answerLiteral, answerLiteralVariables, answerClause, this.maxQueryTime);
        LinkedHashSet<Clause> newClauses = new LinkedHashSet<Clause>();
        LinkedHashSet<Clause> toAdd = new LinkedHashSet<Clause>();
        int noOfPrevClauses = clauses.size();
        do {
            if (null != this.tracer) {
                this.tracer.stepStartWhile(clauses, clauses.size(), newClauses.size());
            }
            newClauses.clear();
            Clause[] clausesA = new Clause[clauses.size()];
            clauses.toArray(clausesA);
            for (int i = 0; i < clausesA.length; ++i) {
                Clause cI = clausesA[i];
                if (null != this.tracer) {
                    this.tracer.stepOuterFor(cI);
                }
                for (int j = i; j < clausesA.length; ++j) {
                    Set<Clause> resolvents;
                    Clause cJ = clausesA[j];
                    if (null != this.tracer) {
                        this.tracer.stepInnerFor(cI, cJ);
                    }
                    if ((resolvents = cI.binaryResolvents(cJ)).size() > 0) {
                        toAdd.clear();
                        for (Clause rc : resolvents) {
                            toAdd.addAll(rc.getFactors());
                        }
                        if (null != this.tracer) {
                            this.tracer.stepResolved(cI, cJ, toAdd);
                        }
                        ansHandler.checkForPossibleAnswers(toAdd);
                        if (ansHandler.isComplete()) break;
                        newClauses.addAll(toAdd);
                    }
                    if (ansHandler.isComplete()) break;
                }
                if (ansHandler.isComplete()) break;
            }
            noOfPrevClauses = clauses.size();
            clauses.addAll(newClauses);
        } while (!ansHandler.isComplete() && noOfPrevClauses < clauses.size());
        if (null != this.tracer) {
            this.tracer.stepFinished(clauses, ansHandler);
        }
        return ansHandler;
    }

    class TFMAnswerHandler
    implements InferenceResult {
        private Literal answerLiteral = null;
        private Set<Variable> answerLiteralVariables = null;
        private Clause answerClause = null;
        private long finishTime = 0L;
        private boolean complete = false;
        private List<Proof> proofs = new ArrayList<Proof>();
        private boolean timedOut = false;

        public TFMAnswerHandler(Literal answerLiteral, Set<Variable> answerLiteralVariables, Clause answerClause, long maxQueryTime) {
            this.answerLiteral = answerLiteral;
            this.answerLiteralVariables = answerLiteralVariables;
            this.answerClause = answerClause;
            this.finishTime = System.currentTimeMillis() + maxQueryTime;
        }

        @Override
        public boolean isPossiblyFalse() {
            return !this.timedOut && this.proofs.size() == 0;
        }

        @Override
        public boolean isTrue() {
            return this.proofs.size() > 0;
        }

        @Override
        public boolean isUnknownDueToTimeout() {
            return this.timedOut && this.proofs.size() == 0;
        }

        @Override
        public boolean isPartialResultDueToTimeout() {
            return this.timedOut && this.proofs.size() > 0;
        }

        @Override
        public List<Proof> getProofs() {
            return this.proofs;
        }

        public boolean isComplete() {
            return this.complete;
        }

        private void checkForPossibleAnswers(Set<Clause> resolvents) {
            for (Clause aClause : resolvents) {
                if (this.answerClause.isEmpty()) {
                    if (aClause.isEmpty()) {
                        this.proofs.add(new ProofFinal(aClause.getProofStep(), new HashMap<Variable, Term>()));
                        this.complete = true;
                    }
                } else {
                    if (aClause.isEmpty()) {
                        throw new IllegalStateException("Generated an empty clause while looking for an answer, implies original KB is unsatisfiable");
                    }
                    if (aClause.isUnitClause() && aClause.isDefiniteClause() && aClause.getPositiveLiterals().get(0).getAtomicSentence().getSymbolicName().equals(this.answerLiteral.getAtomicSentence().getSymbolicName())) {
                        HashMap<Variable, Term> answerBindings = new HashMap<Variable, Term>();
                        List<Term> answerTerms = aClause.getPositiveLiterals().get(0).getAtomicSentence().getArgs();
                        int idx = 0;
                        for (Variable v : this.answerLiteralVariables) {
                            answerBindings.put(v, answerTerms.get(idx));
                            ++idx;
                        }
                        boolean addNewAnswer = true;
                        for (Proof p : this.proofs) {
                            if (!p.getAnswerBindings().equals(answerBindings)) continue;
                            addNewAnswer = false;
                            break;
                        }
                        if (addNewAnswer) {
                            this.proofs.add(new ProofFinal(aClause.getProofStep(), answerBindings));
                        }
                    }
                }
                if (System.currentTimeMillis() <= this.finishTime) continue;
                this.complete = true;
                this.timedOut = true;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("isComplete=" + this.complete);
            sb.append("\n");
            sb.append("result=" + this.proofs);
            return sb.toString();
        }
    }
}

