/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol.inference;

import aima.core.logic.fol.SubsumptionElimination;
import aima.core.logic.fol.inference.InferenceProcedure;
import aima.core.logic.fol.inference.InferenceResult;
import aima.core.logic.fol.inference.Paramodulation;
import aima.core.logic.fol.inference.otter.ClauseFilter;
import aima.core.logic.fol.inference.otter.ClauseSimplifier;
import aima.core.logic.fol.inference.otter.LightestClauseHeuristic;
import aima.core.logic.fol.inference.otter.defaultimpl.DefaultClauseFilter;
import aima.core.logic.fol.inference.otter.defaultimpl.DefaultClauseSimplifier;
import aima.core.logic.fol.inference.otter.defaultimpl.DefaultLightestClauseHeuristic;
import aima.core.logic.fol.inference.proof.Proof;
import aima.core.logic.fol.inference.proof.ProofFinal;
import aima.core.logic.fol.inference.proof.ProofStepGoal;
import aima.core.logic.fol.kb.FOLKnowledgeBase;
import aima.core.logic.fol.kb.data.Clause;
import aima.core.logic.fol.kb.data.Literal;
import aima.core.logic.fol.parsing.ast.ConnectedSentence;
import aima.core.logic.fol.parsing.ast.NotSentence;
import aima.core.logic.fol.parsing.ast.Sentence;
import aima.core.logic.fol.parsing.ast.Term;
import aima.core.logic.fol.parsing.ast.TermEquality;
import aima.core.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FOLOTTERLikeTheoremProver
implements InferenceProcedure {
    private long maxQueryTime = 10000L;
    private boolean useParamodulation = true;
    private LightestClauseHeuristic lightestClauseHeuristic = new DefaultLightestClauseHeuristic();
    private ClauseFilter clauseFilter = new DefaultClauseFilter();
    private ClauseSimplifier clauseSimplifier = new DefaultClauseSimplifier();
    private Paramodulation paramodulation = new Paramodulation();

    public FOLOTTERLikeTheoremProver() {
    }

    public FOLOTTERLikeTheoremProver(long maxQueryTime) {
        this.setMaxQueryTime(maxQueryTime);
    }

    public FOLOTTERLikeTheoremProver(boolean useParamodulation) {
        this.setUseParamodulation(useParamodulation);
    }

    public FOLOTTERLikeTheoremProver(long maxQueryTime, boolean useParamodulation) {
        this.setMaxQueryTime(maxQueryTime);
        this.setUseParamodulation(useParamodulation);
    }

    public long getMaxQueryTime() {
        return this.maxQueryTime;
    }

    public void setMaxQueryTime(long maxQueryTime) {
        this.maxQueryTime = maxQueryTime;
    }

    public boolean isUseParamodulation() {
        return this.useParamodulation;
    }

    public void setUseParamodulation(boolean useParamodulation) {
        this.useParamodulation = useParamodulation;
    }

    public LightestClauseHeuristic getLightestClauseHeuristic() {
        return this.lightestClauseHeuristic;
    }

    public void setLightestClauseHeuristic(LightestClauseHeuristic lightestClauseHeuristic) {
        this.lightestClauseHeuristic = lightestClauseHeuristic;
    }

    public ClauseFilter getClauseFilter() {
        return this.clauseFilter;
    }

    public void setClauseFilter(ClauseFilter clauseFilter) {
        this.clauseFilter = clauseFilter;
    }

    public ClauseSimplifier getClauseSimplifier() {
        return this.clauseSimplifier;
    }

    public void setClauseSimplifier(ClauseSimplifier clauseSimplifier) {
        this.clauseSimplifier = clauseSimplifier;
    }

    @Override
    public InferenceResult ask(FOLKnowledgeBase KB, Sentence alpha) {
        HashSet<Clause> sos = new HashSet<Clause>();
        HashSet<Clause> usable = new HashSet<Clause>();
        for (Clause c : KB.getAllClauses()) {
            c = KB.standardizeApart(c);
            c.setStandardizedApartCheckNotRequired();
            usable.addAll(c.getFactors());
        }
        if (this.isUseParamodulation()) {
            TermEquality reflexivityAxiom = new TermEquality(new Variable("x"), new Variable("x"));
            Clause reflexivityClause = new Clause();
            reflexivityClause.addLiteral(new Literal(reflexivityAxiom));
            reflexivityClause = KB.standardizeApart(reflexivityClause);
            reflexivityClause.setStandardizedApartCheckNotRequired();
            usable.add(reflexivityClause);
        }
        NotSentence notAlpha = new NotSentence(alpha);
        Literal answerLiteral = KB.createAnswerLiteral(notAlpha);
        Set<Variable> answerLiteralVariables = KB.collectAllVariables(answerLiteral.getAtomicSentence());
        Clause answerClause = new Clause();
        if (answerLiteralVariables.size() > 0) {
            ConnectedSentence notAlphaWithAnswer = new ConnectedSentence("OR", notAlpha, answerLiteral.getAtomicSentence());
            for (Clause c : KB.convertToClauses(notAlphaWithAnswer)) {
                c = KB.standardizeApart(c);
                c.setProofStep(new ProofStepGoal(c));
                c.setStandardizedApartCheckNotRequired();
                sos.addAll(c.getFactors());
            }
            answerClause.addLiteral(answerLiteral);
        } else {
            for (Clause c : KB.convertToClauses(notAlpha)) {
                c = KB.standardizeApart(c);
                c.setProofStep(new ProofStepGoal(c));
                c.setStandardizedApartCheckNotRequired();
                sos.addAll(c.getFactors());
            }
        }
        usable.removeAll(SubsumptionElimination.findSubsumedClauses(usable));
        sos.removeAll(SubsumptionElimination.findSubsumedClauses(sos));
        OTTERAnswerHandler ansHandler = new OTTERAnswerHandler(answerLiteral, answerLiteralVariables, answerClause, this.maxQueryTime);
        IndexedClauses idxdClauses = new IndexedClauses(this.getLightestClauseHeuristic(), sos, usable);
        return this.otter(ansHandler, idxdClauses, sos, usable);
    }

    private InferenceResult otter(OTTERAnswerHandler ansHandler, IndexedClauses idxdClauses, Set<Clause> sos, Set<Clause> usable) {
        this.getLightestClauseHeuristic().initialSOS(sos);
        do {
            Clause clause;
            if (null == (clause = this.getLightestClauseHeuristic().getLightestClause())) continue;
            sos.remove(clause);
            this.getLightestClauseHeuristic().removedClauseFromSOS(clause);
            usable.add(clause);
            this.process(ansHandler, idxdClauses, this.infer(clause, usable), sos, usable);
        } while (sos.size() != 0 && !ansHandler.isComplete());
        return ansHandler;
    }

    private Set<Clause> infer(Clause clause, Set<Clause> usable) {
        LinkedHashSet<Clause> resultingClauses = new LinkedHashSet<Clause>();
        for (Clause c : usable) {
            Set<Clause> resolvents = clause.binaryResolvents(c);
            for (Clause rc : resolvents) {
                resultingClauses.add(rc);
            }
            if (!this.isUseParamodulation()) continue;
            Set<Clause> paras = this.paramodulation.apply(clause, c, true);
            for (Clause p : paras) {
                resultingClauses.add(p);
            }
        }
        return this.getClauseFilter().filter(resultingClauses);
    }

    private void process(OTTERAnswerHandler ansHandler, IndexedClauses idxdClauses, Set<Clause> clauses, Set<Clause> sos, Set<Clause> usable) {
        for (Clause clause : clauses) {
            clause = this.getClauseSimplifier().simplify(clause);
            if (clause.isTautology()) continue;
            if (!(ansHandler.isAnswer(clause) || sos.contains(clause) || usable.contains(clause))) {
                for (Clause ac : clause.getFactors()) {
                    if (sos.contains(ac) || usable.contains(ac)) continue;
                    idxdClauses.addClause(ac, sos, usable);
                    this.lookForUnitRefutation(ansHandler, idxdClauses, ac, sos, usable);
                }
            }
            if (!ansHandler.isComplete()) continue;
            break;
        }
    }

    private void lookForUnitRefutation(OTTERAnswerHandler ansHandler, IndexedClauses idxdClauses, Clause clause, Set<Clause> sos, Set<Clause> usable) {
        Set<Clause> toCheck = new LinkedHashSet<Clause>();
        if (ansHandler.isCheckForUnitRefutation(clause)) {
            for (Clause s : sos) {
                if (!s.isUnitClause()) continue;
                toCheck.add(s);
            }
            for (Clause u : usable) {
                if (!u.isUnitClause()) continue;
                toCheck.add(u);
            }
        }
        if (toCheck.size() > 0) {
            toCheck = this.infer(clause, toCheck);
            for (Clause t : toCheck) {
                t = this.getClauseSimplifier().simplify(t);
                if (t.isTautology()) continue;
                if (!(ansHandler.isAnswer(t) || sos.contains(t) || usable.contains(t))) {
                    idxdClauses.addClause(t, sos, usable);
                }
                if (!ansHandler.isComplete()) continue;
                break;
            }
        }
    }

    class OTTERAnswerHandler
    implements InferenceResult {
        private Literal answerLiteral = null;
        private Set<Variable> answerLiteralVariables = null;
        private Clause answerClause = null;
        private long finishTime = 0L;
        private boolean complete = false;
        private List<Proof> proofs = new ArrayList<Proof>();
        private boolean timedOut = false;

        public OTTERAnswerHandler(Literal answerLiteral, Set<Variable> answerLiteralVariables, Clause answerClause, long maxQueryTime) {
            this.answerLiteral = answerLiteral;
            this.answerLiteralVariables = answerLiteralVariables;
            this.answerClause = answerClause;
            this.finishTime = System.currentTimeMillis() + maxQueryTime;
        }

        @Override
        public boolean isPossiblyFalse() {
            return !this.timedOut && this.proofs.size() == 0;
        }

        @Override
        public boolean isTrue() {
            return this.proofs.size() > 0;
        }

        @Override
        public boolean isUnknownDueToTimeout() {
            return this.timedOut && this.proofs.size() == 0;
        }

        @Override
        public boolean isPartialResultDueToTimeout() {
            return this.timedOut && this.proofs.size() > 0;
        }

        @Override
        public List<Proof> getProofs() {
            return this.proofs;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public boolean isLookingForAnswerLiteral() {
            return !this.answerClause.isEmpty();
        }

        public boolean isCheckForUnitRefutation(Clause clause) {
            if (this.isLookingForAnswerLiteral()) {
                if (2 == clause.getNumberLiterals()) {
                    for (Literal t : clause.getLiterals()) {
                        if (!t.getAtomicSentence().getSymbolicName().equals(this.answerLiteral.getAtomicSentence().getSymbolicName())) continue;
                        return true;
                    }
                }
            } else {
                return clause.isUnitClause();
            }
            return false;
        }

        public boolean isAnswer(Clause clause) {
            boolean isAns = false;
            if (this.answerClause.isEmpty()) {
                if (clause.isEmpty()) {
                    this.proofs.add(new ProofFinal(clause.getProofStep(), new HashMap<Variable, Term>()));
                    this.complete = true;
                    isAns = true;
                }
            } else {
                if (clause.isEmpty()) {
                    throw new IllegalStateException("Generated an empty clause while looking for an answer, implies original KB or usable is unsatisfiable");
                }
                if (clause.isUnitClause() && clause.isDefiniteClause() && clause.getPositiveLiterals().get(0).getAtomicSentence().getSymbolicName().equals(this.answerLiteral.getAtomicSentence().getSymbolicName())) {
                    HashMap<Variable, Term> answerBindings = new HashMap<Variable, Term>();
                    List<Term> answerTerms = clause.getPositiveLiterals().get(0).getAtomicSentence().getArgs();
                    int idx = 0;
                    for (Variable v : this.answerLiteralVariables) {
                        answerBindings.put(v, answerTerms.get(idx));
                        ++idx;
                    }
                    boolean addNewAnswer = true;
                    for (Proof p : this.proofs) {
                        if (!p.getAnswerBindings().equals(answerBindings)) continue;
                        addNewAnswer = false;
                        break;
                    }
                    if (addNewAnswer) {
                        this.proofs.add(new ProofFinal(clause.getProofStep(), answerBindings));
                    }
                    isAns = true;
                }
            }
            if (System.currentTimeMillis() > this.finishTime) {
                this.complete = true;
                this.timedOut = true;
            }
            return isAns;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("isComplete=" + this.complete);
            sb.append("\n");
            sb.append("result=" + this.proofs);
            return sb.toString();
        }
    }

    class IndexedClauses {
        private LightestClauseHeuristic lightestClauseHeuristic = null;
        private Map<Integer, Set<Clause>> clausesGroupedBySize = new HashMap<Integer, Set<Clause>>();
        private int minNoLiterals = Integer.MAX_VALUE;
        private int maxNoLiterals = 0;

        public IndexedClauses(LightestClauseHeuristic lightestClauseHeuristic, Set<Clause> sos, Set<Clause> usable) {
            this.lightestClauseHeuristic = lightestClauseHeuristic;
            for (Clause c : sos) {
                this.indexClause(c);
            }
            for (Clause c : usable) {
                this.indexClause(c);
            }
        }

        public void addClause(Clause c, Set<Clause> sos, Set<Clause> usable) {
            boolean addToSOS = true;
            for (int i = this.minNoLiterals; i < c.getNumberLiterals(); ++i) {
                Set<Clause> fs = this.clausesGroupedBySize.get(i);
                if (null != fs) {
                    for (Clause s : fs) {
                        if (!s.subsumes(c)) continue;
                        addToSOS = false;
                        break;
                    }
                }
                if (!addToSOS) break;
            }
            if (addToSOS) {
                sos.add(c);
                this.lightestClauseHeuristic.addedClauseToSOS(c);
                this.indexClause(c);
                HashSet<Clause> subsumed = new HashSet<Clause>();
                for (int i = c.getNumberLiterals() + 1; i <= this.maxNoLiterals; ++i) {
                    subsumed.clear();
                    Set<Clause> bs = this.clausesGroupedBySize.get(i);
                    if (null == bs) continue;
                    for (Clause s : bs) {
                        if (!c.subsumes(s)) continue;
                        subsumed.add(s);
                        if (sos.contains(s)) {
                            sos.remove(s);
                            this.lightestClauseHeuristic.removedClauseFromSOS(s);
                        }
                        usable.remove(s);
                    }
                    bs.removeAll(subsumed);
                }
            }
        }

        private void indexClause(Clause c) {
            Set<Clause> cforsize;
            int size = c.getNumberLiterals();
            if (size < this.minNoLiterals) {
                this.minNoLiterals = size;
            }
            if (size > this.maxNoLiterals) {
                this.maxNoLiterals = size;
            }
            if (null == (cforsize = this.clausesGroupedBySize.get(size))) {
                cforsize = new HashSet<Clause>();
                this.clausesGroupedBySize.put(size, cforsize);
            }
            cforsize.add(c);
        }
    }
}

