/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol.inference;

import aima.core.logic.fol.inference.AbstractModulation;
import aima.core.logic.fol.inference.proof.ProofStepClauseDemodulation;
import aima.core.logic.fol.kb.data.Clause;
import aima.core.logic.fol.kb.data.Literal;
import aima.core.logic.fol.parsing.ast.AtomicSentence;
import aima.core.logic.fol.parsing.ast.Term;
import aima.core.logic.fol.parsing.ast.TermEquality;
import aima.core.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class Demodulation
extends AbstractModulation {
    public Clause apply(TermEquality assertion, Clause clExpression) {
        Clause altClExpression = null;
        for (Literal l1 : clExpression.getLiterals()) {
            AtomicSentence altExpression = this.apply(assertion, l1.getAtomicSentence());
            if (null == altExpression) continue;
            ArrayList<Literal> newLits = new ArrayList<Literal>();
            for (Literal l2 : clExpression.getLiterals()) {
                if (l1.equals(l2)) {
                    newLits.add(l1.newInstance(altExpression));
                    continue;
                }
                newLits.add(l2);
            }
            altClExpression = new Clause(newLits);
            altClExpression.setProofStep(new ProofStepClauseDemodulation(altClExpression, clExpression, assertion));
            if (clExpression.isImmutable()) {
                altClExpression.setImmutable();
            }
            if (clExpression.isStandardizedApartCheckRequired()) break;
            altClExpression.setStandardizedApartCheckNotRequired();
            break;
        }
        return altClExpression;
    }

    public AtomicSentence apply(TermEquality assertion, AtomicSentence expression) {
        AtomicSentence altExpression = null;
        AbstractModulation.IdentifyCandidateMatchingTerm icm = this.getMatchingSubstitution(assertion.getTerm1(), expression);
        if (null != icm) {
            Term replaceWith = this.substVisitor.subst(icm.getMatchingSubstitution(), assertion.getTerm2());
            if (!icm.getMatchingTerm().equals(replaceWith)) {
                AbstractModulation.ReplaceMatchingTerm rmt = new AbstractModulation.ReplaceMatchingTerm();
                altExpression = rmt.replace(expression, icm.getMatchingTerm(), replaceWith);
            }
        }
        return altExpression;
    }

    @Override
    protected boolean isValidMatch(Term toMatch, Set<Variable> toMatchVariables, Term possibleMatch, Map<Variable, Term> substitution) {
        return toMatchVariables.containsAll(substitution.keySet());
    }
}

