/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol.domain;

import aima.core.logic.fol.domain.FOLDomainAnswerLiteralAddedEvent;
import aima.core.logic.fol.domain.FOLDomainEvent;
import aima.core.logic.fol.domain.FOLDomainListener;
import aima.core.logic.fol.domain.FOLDomainSkolemConstantAddedEvent;
import aima.core.logic.fol.domain.FOLDomainSkolemFunctionAddedEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FOLDomain {
    private Set<String> constants;
    private Set<String> functions;
    private Set<String> predicates;
    private int skolemConstantIndexical = 0;
    private int skolemFunctionIndexical = 0;
    private int answerLiteralIndexical = 0;
    private List<FOLDomainListener> listeners = new ArrayList<FOLDomainListener>();

    public FOLDomain() {
        this.constants = new HashSet<String>();
        this.functions = new HashSet<String>();
        this.predicates = new HashSet<String>();
    }

    public FOLDomain(FOLDomain toCopy) {
        this(toCopy.getConstants(), toCopy.getFunctions(), toCopy.getPredicates());
    }

    public FOLDomain(Set<String> constants, Set<String> functions, Set<String> predicates) {
        this.constants = new HashSet<String>(constants);
        this.functions = new HashSet<String>(functions);
        this.predicates = new HashSet<String>(predicates);
    }

    public Set<String> getConstants() {
        return this.constants;
    }

    public Set<String> getFunctions() {
        return this.functions;
    }

    public Set<String> getPredicates() {
        return this.predicates;
    }

    public void addConstant(String constant) {
        this.constants.add(constant);
    }

    public String addSkolemConstant() {
        String sc = null;
        while (this.constants.contains(sc = "SC" + this.skolemConstantIndexical++) || this.functions.contains(sc) || this.predicates.contains(sc)) {
        }
        this.addConstant(sc);
        this.notifyFOLDomainListeners(new FOLDomainSkolemConstantAddedEvent(this, sc));
        return sc;
    }

    public void addFunction(String function) {
        this.functions.add(function);
    }

    public String addSkolemFunction() {
        String sf = null;
        while (this.constants.contains(sf = "SF" + this.skolemFunctionIndexical++) || this.functions.contains(sf) || this.predicates.contains(sf)) {
        }
        this.addFunction(sf);
        this.notifyFOLDomainListeners(new FOLDomainSkolemFunctionAddedEvent(this, sf));
        return sf;
    }

    public void addPredicate(String predicate) {
        this.predicates.add(predicate);
    }

    public String addAnswerLiteral() {
        String al = null;
        while (this.constants.contains(al = "Answer" + this.answerLiteralIndexical++) || this.functions.contains(al) || this.predicates.contains(al)) {
        }
        this.addPredicate(al);
        this.notifyFOLDomainListeners(new FOLDomainAnswerLiteralAddedEvent(this, al));
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFOLDomainListener(FOLDomainListener listener) {
        List<FOLDomainListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFOLDomainListener(FOLDomainListener listener) {
        List<FOLDomainListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFOLDomainListeners(FOLDomainEvent event) {
        List<FOLDomainListener> list = this.listeners;
        synchronized (list) {
            for (FOLDomainListener l : this.listeners) {
                event.notifyListener(l);
            }
        }
    }
}

