/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol;

import aima.core.logic.fol.kb.data.Chain;
import aima.core.logic.fol.kb.data.Clause;
import aima.core.logic.fol.kb.data.Literal;
import aima.core.logic.fol.parsing.FOLVisitor;
import aima.core.logic.fol.parsing.ast.ConnectedSentence;
import aima.core.logic.fol.parsing.ast.Constant;
import aima.core.logic.fol.parsing.ast.Function;
import aima.core.logic.fol.parsing.ast.NotSentence;
import aima.core.logic.fol.parsing.ast.Predicate;
import aima.core.logic.fol.parsing.ast.QuantifiedSentence;
import aima.core.logic.fol.parsing.ast.Sentence;
import aima.core.logic.fol.parsing.ast.Term;
import aima.core.logic.fol.parsing.ast.TermEquality;
import aima.core.logic.fol.parsing.ast.Variable;
import java.util.LinkedHashSet;
import java.util.Set;

public class VariableCollector
implements FOLVisitor {
    public Set<Variable> collectAllVariables(Sentence sentence) {
        LinkedHashSet<Variable> variables = new LinkedHashSet<Variable>();
        sentence.accept(this, variables);
        return variables;
    }

    public Set<Variable> collectAllVariables(Term term) {
        LinkedHashSet<Variable> variables = new LinkedHashSet<Variable>();
        term.accept(this, variables);
        return variables;
    }

    public Set<Variable> collectAllVariables(Clause clause) {
        LinkedHashSet<Variable> variables = new LinkedHashSet<Variable>();
        for (Literal l : clause.getLiterals()) {
            l.getAtomicSentence().accept(this, variables);
        }
        return variables;
    }

    public Set<Variable> collectAllVariables(Chain chain) {
        LinkedHashSet<Variable> variables = new LinkedHashSet<Variable>();
        for (Literal l : chain.getLiterals()) {
            l.getAtomicSentence().accept(this, variables);
        }
        return variables;
    }

    @Override
    public Object visitVariable(Variable var, Object arg) {
        Set variables = (Set)arg;
        variables.add(var);
        return var;
    }

    @Override
    public Object visitQuantifiedSentence(QuantifiedSentence sentence, Object arg) {
        Set variables = (Set)arg;
        variables.addAll(sentence.getVariables());
        sentence.getQuantified().accept(this, arg);
        return sentence;
    }

    @Override
    public Object visitPredicate(Predicate predicate, Object arg) {
        for (Term t : predicate.getTerms()) {
            t.accept(this, arg);
        }
        return predicate;
    }

    @Override
    public Object visitTermEquality(TermEquality equality, Object arg) {
        equality.getTerm1().accept(this, arg);
        equality.getTerm2().accept(this, arg);
        return equality;
    }

    @Override
    public Object visitConstant(Constant constant, Object arg) {
        return constant;
    }

    @Override
    public Object visitFunction(Function function, Object arg) {
        for (Term t : function.getTerms()) {
            t.accept(this, arg);
        }
        return function;
    }

    @Override
    public Object visitNotSentence(NotSentence sentence, Object arg) {
        sentence.getNegated().accept(this, arg);
        return sentence;
    }

    @Override
    public Object visitConnectedSentence(ConnectedSentence sentence, Object arg) {
        sentence.getFirst().accept(this, arg);
        sentence.getSecond().accept(this, arg);
        return sentence;
    }
}

