/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol;

import aima.core.logic.fol.SubstVisitor;
import aima.core.logic.fol.parsing.ast.FOLNode;
import aima.core.logic.fol.parsing.ast.Function;
import aima.core.logic.fol.parsing.ast.Term;
import aima.core.logic.fol.parsing.ast.Variable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Unifier {
    private static SubstVisitor _substVisitor = new SubstVisitor();

    public Map<Variable, Term> unify(FOLNode x, FOLNode y) {
        return this.unify(x, y, new LinkedHashMap<Variable, Term>());
    }

    public Map<Variable, Term> unify(FOLNode x, FOLNode y, Map<Variable, Term> theta) {
        if (theta == null) {
            return null;
        }
        if (x.equals(y)) {
            return theta;
        }
        if (x instanceof Variable) {
            return this.unifyVar((Variable)x, y, theta);
        }
        if (y instanceof Variable) {
            return this.unifyVar((Variable)y, x, theta);
        }
        if (this.isCompound(x) && this.isCompound(y)) {
            return this.unify(this.args(x), this.args(y), this.unifyOps(this.op(x), this.op(y), theta));
        }
        return null;
    }

    public Map<Variable, Term> unify(List<? extends FOLNode> x, List<? extends FOLNode> y, Map<Variable, Term> theta) {
        if (theta == null) {
            return null;
        }
        if (x.size() != y.size()) {
            return null;
        }
        if (x.size() == 0 && y.size() == 0) {
            return theta;
        }
        if (x.size() == 1 && y.size() == 1) {
            return this.unify(x.get(0), y.get(0), theta);
        }
        return this.unify(x.subList(1, x.size()), y.subList(1, y.size()), this.unify(x.get(0), y.get(0), theta));
    }

    protected boolean occurCheck(Map<Variable, Term> theta, Variable var, FOLNode x) {
        if (var.equals(x)) {
            return true;
        }
        if (theta.containsKey(x)) {
            return this.occurCheck(theta, var, theta.get(x));
        }
        if (x instanceof Function) {
            Function fx = (Function)x;
            for (Term fxt : fx.getArgs()) {
                if (!this.occurCheck(theta, var, fxt)) continue;
                return true;
            }
        }
        return false;
    }

    private Map<Variable, Term> unifyVar(Variable var, FOLNode x, Map<Variable, Term> theta) {
        if (!Term.class.isInstance(x)) {
            return null;
        }
        if (theta.keySet().contains(var)) {
            return this.unify(theta.get(var), x, theta);
        }
        if (theta.keySet().contains(x)) {
            return this.unify(var, theta.get(x), theta);
        }
        if (this.occurCheck(theta, var, x)) {
            return null;
        }
        this.cascadeSubstitution(theta, var, (Term)x);
        return theta;
    }

    private Map<Variable, Term> unifyOps(String x, String y, Map<Variable, Term> theta) {
        if (theta == null) {
            return null;
        }
        if (x.equals(y)) {
            return theta;
        }
        return null;
    }

    private List<? extends FOLNode> args(FOLNode x) {
        return x.getArgs();
    }

    private String op(FOLNode x) {
        return x.getSymbolicName();
    }

    private boolean isCompound(FOLNode x) {
        return x.isCompound();
    }

    private Map<Variable, Term> cascadeSubstitution(Map<Variable, Term> theta, Variable var, Term x) {
        theta.put(var, x);
        for (Variable v : theta.keySet()) {
            theta.put(v, _substVisitor.subst(theta, theta.get(v)));
        }
        for (Variable v : theta.keySet()) {
            Term t = theta.get(v);
            if (!(t instanceof Function)) continue;
            theta.put(v, _substVisitor.subst(theta, t));
        }
        return theta;
    }
}

