/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol;

import aima.core.logic.fol.kb.data.Clause;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class SubsumptionElimination {
    public static Set<Clause> findSubsumedClauses(Set<Clause> clauses) {
        HashSet<Clause> subsumed = new HashSet<Clause>();
        int min = Integer.MAX_VALUE;
        int max = 0;
        HashMap<Integer, HashSet<Clause>> clausesGroupedBySize = new HashMap<Integer, HashSet<Clause>>();
        for (Clause c : clauses) {
            HashSet<Clause> cforsize;
            int size = c.getNumberLiterals();
            if (size < min) {
                min = size;
            }
            if (size > max) {
                max = size;
            }
            if (null == (cforsize = (HashSet<Clause>)clausesGroupedBySize.get(size))) {
                cforsize = new HashSet<Clause>();
                clausesGroupedBySize.put(size, cforsize);
            }
            cforsize.add(c);
        }
        for (int i = min; i < max; ++i) {
            Set scs = (Set)clausesGroupedBySize.get(i);
            if (null == scs) continue;
            for (int j = i + 1; j <= max; ++j) {
                Set lcs = (Set)clausesGroupedBySize.get(j);
                if (null == lcs) continue;
                for (Clause sc : scs) {
                    if (subsumed.contains(sc)) continue;
                    for (Clause lc : lcs) {
                        if (subsumed.contains(lc) || !sc.subsumes(lc)) continue;
                        subsumed.add(lc);
                    }
                }
            }
        }
        return subsumed;
    }
}

