/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol;

import aima.core.logic.fol.kb.data.Literal;
import aima.core.logic.fol.parsing.AbstractFOLVisitor;
import aima.core.logic.fol.parsing.ast.AtomicSentence;
import aima.core.logic.fol.parsing.ast.Function;
import aima.core.logic.fol.parsing.ast.QuantifiedSentence;
import aima.core.logic.fol.parsing.ast.Sentence;
import aima.core.logic.fol.parsing.ast.Term;
import aima.core.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.Map;

public class SubstVisitor
extends AbstractFOLVisitor {
    public Sentence subst(Map<Variable, Term> theta, Sentence sentence) {
        return (Sentence)sentence.accept(this, theta);
    }

    public Term subst(Map<Variable, Term> theta, Term aTerm) {
        return (Term)aTerm.accept(this, theta);
    }

    public Function subst(Map<Variable, Term> theta, Function function) {
        return (Function)function.accept(this, theta);
    }

    public Literal subst(Map<Variable, Term> theta, Literal literal) {
        return literal.newInstance((AtomicSentence)literal.getAtomicSentence().accept(this, theta));
    }

    @Override
    public Object visitVariable(Variable variable, Object arg) {
        Map substitution = (Map)arg;
        if (substitution.containsKey(variable)) {
            return ((Term)substitution.get(variable)).copy();
        }
        return variable.copy();
    }

    @Override
    public Object visitQuantifiedSentence(QuantifiedSentence sentence, Object arg) {
        Map substitution = (Map)arg;
        Sentence quantified = sentence.getQuantified();
        Sentence quantifiedAfterSubs = (Sentence)quantified.accept(this, arg);
        ArrayList<Variable> variables = new ArrayList<Variable>();
        for (Variable v : sentence.getVariables()) {
            Term st = (Term)substitution.get(v);
            if (null != st) {
                if (!(st instanceof Variable)) continue;
                variables.add((Variable)st.copy());
                continue;
            }
            variables.add(v.copy());
        }
        if (variables.size() == 0) {
            return quantifiedAfterSubs;
        }
        return new QuantifiedSentence(sentence.getQuantifier(), variables, quantifiedAfterSubs);
    }
}

