/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol;

import aima.core.logic.fol.StandardizeApartIndexical;
import aima.core.logic.fol.SubstVisitor;
import aima.core.logic.fol.parsing.FOLVisitor;
import aima.core.logic.fol.parsing.ast.ConnectedSentence;
import aima.core.logic.fol.parsing.ast.Constant;
import aima.core.logic.fol.parsing.ast.Function;
import aima.core.logic.fol.parsing.ast.NotSentence;
import aima.core.logic.fol.parsing.ast.Predicate;
import aima.core.logic.fol.parsing.ast.QuantifiedSentence;
import aima.core.logic.fol.parsing.ast.Sentence;
import aima.core.logic.fol.parsing.ast.Term;
import aima.core.logic.fol.parsing.ast.TermEquality;
import aima.core.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Set;

class StandardizeQuantiferVariables
implements FOLVisitor {
    private StandardizeApartIndexical quantifiedIndexical = new StandardizeApartIndexical(){
        private int index = 0;

        @Override
        public String getPrefix() {
            return "q";
        }

        @Override
        public int getNextIndex() {
            return this.index++;
        }
    };
    private SubstVisitor substVisitor = null;

    public StandardizeQuantiferVariables(SubstVisitor substVisitor) {
        this.substVisitor = substVisitor;
    }

    @Override
    public Object visitPredicate(Predicate p, Object arg) {
        return p;
    }

    @Override
    public Object visitTermEquality(TermEquality equality, Object arg) {
        return equality;
    }

    @Override
    public Object visitVariable(Variable variable, Object arg) {
        return variable;
    }

    @Override
    public Object visitConstant(Constant constant, Object arg) {
        return constant;
    }

    @Override
    public Object visitFunction(Function function, Object arg) {
        return function;
    }

    @Override
    public Object visitNotSentence(NotSentence sentence, Object arg) {
        return new NotSentence((Sentence)sentence.getNegated().accept(this, arg));
    }

    @Override
    public Object visitConnectedSentence(ConnectedSentence sentence, Object arg) {
        return new ConnectedSentence(sentence.getConnector(), (Sentence)sentence.getFirst().accept(this, arg), (Sentence)sentence.getSecond().accept(this, arg));
    }

    @Override
    public Object visitQuantifiedSentence(QuantifiedSentence sentence, Object arg) {
        Set seenSoFar = (Set)arg;
        LinkedHashMap<Variable, Term> localSubst = new LinkedHashMap<Variable, Term>();
        ArrayList<Variable> replVariables = new ArrayList<Variable>();
        for (Variable v : sentence.getVariables()) {
            if (seenSoFar.contains(v)) {
                Variable sV = new Variable(this.quantifiedIndexical.getPrefix() + this.quantifiedIndexical.getNextIndex());
                localSubst.put(v, sV);
                replVariables.add(sV);
                continue;
            }
            replVariables.add(v);
        }
        Sentence subst = this.substVisitor.subst(localSubst, sentence.getQuantified());
        seenSoFar.addAll(replVariables);
        Sentence sQuantified = (Sentence)subst.accept(this, arg);
        return new QuantifiedSentence(sentence.getQuantifier(), replVariables, sQuantified);
    }
}

