/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol;

import aima.core.logic.fol.CollectAllVariables;
import aima.core.logic.fol.kb.data.Chain;
import aima.core.logic.fol.kb.data.Clause;
import aima.core.logic.fol.kb.data.Literal;
import aima.core.logic.fol.parsing.ast.Sentence;
import aima.core.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StandardizeApartInPlace {
    private static CollectAllVariables _collectAllVariables = new CollectAllVariables();

    public static int standardizeApart(Chain c, int saIdx) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        for (Literal l : c.getLiterals()) {
            StandardizeApartInPlace.collectAllVariables(l.getAtomicSentence(), variables);
        }
        return StandardizeApartInPlace.standardizeApart(variables, c, saIdx);
    }

    public static int standardizeApart(Clause c, int saIdx) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        for (Literal l : c.getLiterals()) {
            StandardizeApartInPlace.collectAllVariables(l.getAtomicSentence(), variables);
        }
        return StandardizeApartInPlace.standardizeApart(variables, c, saIdx);
    }

    private static int standardizeApart(List<Variable> variables, Object expr, int saIdx) {
        HashMap<String, Integer> indexicals = new HashMap<String, Integer>();
        for (Variable v : variables) {
            if (indexicals.containsKey(v.getIndexedValue())) continue;
            indexicals.put(v.getIndexedValue(), saIdx++);
        }
        for (Variable v : variables) {
            Integer i = (Integer)indexicals.get(v.getIndexedValue());
            if (null == i) {
                throw new RuntimeException("ERROR: duplicate var=" + v + ", expr=" + expr);
            }
            v.setIndexical(i);
        }
        return saIdx;
    }

    private static void collectAllVariables(Sentence s, List<Variable> vars) {
        s.accept(_collectAllVariables, vars);
    }
}

