/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.fol;

import aima.core.logic.fol.CNFConstructor;
import aima.core.logic.fol.DistributeOrOverAnd;
import aima.core.logic.fol.ImplicationsOut;
import aima.core.logic.fol.NegationsIn;
import aima.core.logic.fol.RemoveQuantifiers;
import aima.core.logic.fol.StandardizeQuantiferVariables;
import aima.core.logic.fol.SubstVisitor;
import aima.core.logic.fol.kb.data.CNF;
import aima.core.logic.fol.parsing.FOLParser;
import aima.core.logic.fol.parsing.ast.Sentence;
import java.util.LinkedHashSet;

public class CNFConverter {
    private FOLParser parser = null;
    private SubstVisitor substVisitor;

    public CNFConverter(FOLParser parser) {
        this.parser = parser;
        this.substVisitor = new SubstVisitor();
    }

    public CNF convertToCNF(Sentence aSentence) {
        Sentence implicationsOut = (Sentence)aSentence.accept(new ImplicationsOut(), null);
        Sentence negationsIn = (Sentence)implicationsOut.accept(new NegationsIn(), null);
        Sentence saQuantifiers = (Sentence)negationsIn.accept(new StandardizeQuantiferVariables(this.substVisitor), new LinkedHashSet());
        Sentence andsAndOrs = (Sentence)saQuantifiers.accept(new RemoveQuantifiers(this.parser), new LinkedHashSet());
        Sentence orDistributedOverAnd = (Sentence)andsAndOrs.accept(new DistributeOrOverAnd(), null);
        return new CNFConstructor().construct(orDistributedOverAnd);
    }
}

