/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.common;

import aima.core.logic.common.Lexer;
import aima.core.logic.common.LexerException;
import aima.core.logic.common.ParserException;
import aima.core.logic.common.Token;
import java.io.Reader;
import java.io.StringReader;

public abstract class Parser<S> {
    protected int lookAheadBufferSize = 1;
    private Token[] lookAheadBuffer = null;

    public abstract Lexer getLexer();

    public S parse(String input) {
        return this.parse(new StringReader(input));
    }

    public S parse(Reader inputReader) {
        S result = null;
        try {
            this.getLexer().setInput(inputReader);
            this.initializeLookAheadBuffer();
            result = this.parse();
        }
        catch (LexerException le) {
            throw new ParserException("Lexer Exception thrown during parsing at position " + le.getCurrentPositionInInputExceptionThrown(), (Throwable)le, new Token[0]);
        }
        return result;
    }

    protected abstract S parse();

    protected Token lookAhead(int i) {
        return this.lookAheadBuffer[i - 1];
    }

    protected void consume() {
        this.loadNextTokenFromInput();
    }

    protected void match(String toMatchSymbol) {
        if (!this.lookAhead(1).getText().equals(toMatchSymbol)) {
            throw new ParserException("Parser: Syntax error detected at match. Expected " + toMatchSymbol + " but got " + this.lookAhead(1).getText(), this.lookAhead(1));
        }
        this.consume();
    }

    private void initializeLookAheadBuffer() {
        this.lookAheadBuffer = new Token[this.lookAheadBufferSize];
        for (int i = 0; i < this.lookAheadBufferSize; ++i) {
            this.lookAheadBuffer[i] = this.getLexer().nextToken();
            if (this.isEndOfInput(this.lookAheadBuffer[i])) break;
        }
    }

    private void loadNextTokenFromInput() {
        boolean eoiEncountered = false;
        for (int i = 0; i < this.lookAheadBufferSize - 1; ++i) {
            this.lookAheadBuffer[i] = this.lookAheadBuffer[i + 1];
            if (!this.isEndOfInput(this.lookAheadBuffer[i])) continue;
            eoiEncountered = true;
            break;
        }
        if (!eoiEncountered) {
            this.lookAheadBuffer[this.lookAheadBufferSize - 1] = this.getLexer().nextToken();
        }
    }

    private boolean isEndOfInput(Token t) {
        return t == null || t.getType() == 9999;
    }
}

