/*
 * Decompiled with CFR 0.152.
 */
package aima.core.logic.common;

import aima.core.logic.common.LexerException;
import aima.core.logic.common.Token;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public abstract class Lexer {
    protected int lookAheadBufferSize = 1;
    private static final int END_OF_INPUT = -1;
    private Reader input;
    private int[] lookAheadBuffer;
    private int currentPositionInInput;

    public void setInput(String inputString) {
        this.setInput(new StringReader(inputString));
    }

    public void setInput(Reader inputReader) {
        this.input = inputReader;
        this.lookAheadBuffer = new int[this.lookAheadBufferSize];
        this.currentPositionInInput = 0;
        this.initializeLookAheadBuffer();
    }

    public abstract Token nextToken();

    protected int getCurrentPositionInInput() {
        return this.currentPositionInInput;
    }

    protected char lookAhead(int position) {
        return (char)this.lookAheadBuffer[position - 1];
    }

    protected void consume() {
        ++this.currentPositionInInput;
        this.loadNextCharacterFromInput();
    }

    private boolean isEndOfInput(int i) {
        return -1 == i;
    }

    private void initializeLookAheadBuffer() {
        int i;
        for (i = 0; i < this.lookAheadBufferSize; ++i) {
            this.lookAheadBuffer[i] = -1;
        }
        for (i = 0; i < this.lookAheadBufferSize; ++i) {
            this.lookAheadBuffer[i] = this.readInput();
            if (this.isEndOfInput(this.lookAheadBuffer[i])) break;
        }
    }

    private void loadNextCharacterFromInput() {
        boolean eoiEncountered = false;
        for (int i = 0; i < this.lookAheadBufferSize - 1; ++i) {
            this.lookAheadBuffer[i] = this.lookAheadBuffer[i + 1];
            if (!this.isEndOfInput(this.lookAheadBuffer[i])) continue;
            eoiEncountered = true;
            break;
        }
        if (!eoiEncountered) {
            this.lookAheadBuffer[this.lookAheadBufferSize - 1] = this.readInput();
        }
    }

    private int readInput() {
        int read = -1;
        try {
            read = this.input.read();
        }
        catch (IOException ioe) {
            throw new LexerException("IOException thrown reading input.", this.currentPositionInInput, ioe);
        }
        return read;
    }
}

