/*
 * Decompiled with CFR 0.152.
 */
package aima.core.learning.reinforcement.example;

import aima.core.agent.Action;
import aima.core.agent.Agent;
import aima.core.agent.Percept;
import aima.core.agent.impl.AbstractEnvironment;
import aima.core.environment.cellworld.Cell;
import aima.core.environment.cellworld.CellWorldAction;
import aima.core.learning.reinforcement.example.CellWorldEnvironmentState;
import aima.core.probability.mdp.TransitionProbabilityFunction;
import aima.core.util.Randomizer;
import java.util.LinkedHashSet;
import java.util.Set;

public class CellWorldEnvironment
extends AbstractEnvironment {
    private Cell<Double> startingCell = null;
    private Set<Cell<Double>> allStates = new LinkedHashSet<Cell<Double>>();
    private TransitionProbabilityFunction<Cell<Double>, CellWorldAction> tpf;
    private Randomizer r = null;
    private CellWorldEnvironmentState currentState = new CellWorldEnvironmentState();

    public CellWorldEnvironment(Cell<Double> startingCell, Set<Cell<Double>> allStates, TransitionProbabilityFunction<Cell<Double>, CellWorldAction> tpf, Randomizer r) {
        this.startingCell = startingCell;
        this.allStates.addAll(allStates);
        this.tpf = tpf;
        this.r = r;
    }

    public void executeTrials(int n) {
        for (int i = 0; i < n; ++i) {
            this.executeTrial();
        }
    }

    public void executeTrial() {
        this.currentState.reset();
        for (Agent a : this.agents) {
            a.setAlive(true);
            this.currentState.setAgentLocation(a, this.startingCell);
        }
        this.stepUntilDone();
    }

    @Override
    public void executeAction(Agent agent, Action action) {
        if (!action.isNoOp()) {
            Cell<Double> s = this.currentState.getAgentLocation(agent);
            double probabilityChoice = this.r.nextDouble();
            double total = 0.0;
            boolean set = false;
            for (Cell<Double> sDelta : this.allStates) {
                if ((total += this.tpf.probability(sDelta, s, (CellWorldAction)action)) > 1.0) {
                    throw new IllegalStateException("Bad probability calculation.");
                }
                if (!(total > probabilityChoice)) continue;
                this.currentState.setAgentLocation(agent, sDelta);
                set = true;
                break;
            }
            if (!set) {
                throw new IllegalStateException("Failed to simulate the action=" + action + " correctly from s=" + s);
            }
        }
    }

    @Override
    public Percept getPerceptSeenBy(Agent anAgent) {
        return this.currentState.getPerceptFor(anAgent);
    }
}

