/*
 * Decompiled with CFR 0.152.
 */
package aima.core.learning.reinforcement.agent;

import aima.core.agent.Action;
import aima.core.learning.reinforcement.PerceptStateReward;
import aima.core.learning.reinforcement.agent.ReinforcementAgent;
import aima.core.util.FrequencyCounter;
import java.util.HashMap;
import java.util.Map;

public class PassiveTDAgent<S, A extends Action>
extends ReinforcementAgent<S, A> {
    private Map<S, A> pi = new HashMap<S, A>();
    private Map<S, Double> U = new HashMap<S, Double>();
    private FrequencyCounter<S> Ns = new FrequencyCounter();
    private S s = null;
    private A a = null;
    private Double r = null;
    private double alpha = 0.0;
    private double gamma = 0.0;

    public PassiveTDAgent(Map<S, A> fixedPolicy, double alpha, double gamma) {
        this.pi.putAll(fixedPolicy);
        this.alpha = alpha;
        this.gamma = gamma;
    }

    @Override
    public A execute(PerceptStateReward<S> percept) {
        S sDelta = percept.state();
        double rDelta = percept.reward();
        if (!this.U.containsKey(sDelta)) {
            this.U.put(sDelta, rDelta);
        }
        if (null != this.s) {
            this.Ns.incrementFor(this.s);
            double U_s = this.U.get(this.s);
            this.U.put(this.s, U_s + this.alpha(this.Ns, this.s) * (this.r + this.gamma * this.U.get(sDelta) - U_s));
        }
        if (this.isTerminal(sDelta)) {
            this.s = null;
            this.a = null;
            this.r = null;
        } else {
            this.s = sDelta;
            this.a = (Action)this.pi.get(sDelta);
            this.r = rDelta;
        }
        return this.a;
    }

    @Override
    public Map<S, Double> getUtility() {
        return new HashMap<S, Double>(this.U);
    }

    @Override
    public void reset() {
        this.U = new HashMap<S, Double>();
        this.Ns.clear();
        this.s = null;
        this.a = null;
        this.r = null;
    }

    protected double alpha(FrequencyCounter<S> Ns, S s) {
        return this.alpha;
    }

    private boolean isTerminal(S s) {
        boolean terminal = false;
        Action a = (Action)this.pi.get(s);
        if (null == a || a.isNoOp()) {
            terminal = true;
        }
        return terminal;
    }
}

