/*
 * Decompiled with CFR 0.152.
 */
package aima.core.learning.neural;

import aima.core.learning.data.DataResource;
import aima.core.learning.framework.DataSet;
import aima.core.learning.framework.Example;
import aima.core.learning.neural.NNExample;
import aima.core.learning.neural.Numerizer;
import aima.core.util.Util;
import aima.core.util.datastructure.Pair;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class NNDataSet {
    private List<NNExample> dataset;
    private List<NNExample> presentlyProcessed = new ArrayList<NNExample>();
    private List<Double> means;
    private List<Double> stdevs;
    protected List<List<Double>> nds;
    protected List<Integer> targetColumnNumbers;

    public abstract void setTargetColumns();

    public void createNormalizedDataFromFile(String filename) throws Exception {
        String line;
        ArrayList<List<Double>> rds = new ArrayList<List<Double>>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(DataResource.class.getResourceAsStream(filename + ".csv")));
        while ((line = reader.readLine()) != null) {
            rds.add(this.exampleFromString(line, ","));
        }
        this.nds = this.normalize(rds);
    }

    public void createNormalizedDataFromDataSet(DataSet ds, Numerizer numerizer) throws Exception {
        List<List<Double>> rds = this.rawExamplesFromDataSet(ds, numerizer);
        this.nds = this.normalize(rds);
    }

    public NNExample getExampleAtRandom() {
        int i = Util.randomNumberBetween(0, this.presentlyProcessed.size() - 1);
        return this.presentlyProcessed.remove(i);
    }

    public NNExample getExample(int index) {
        return this.presentlyProcessed.remove(index);
    }

    public boolean hasMoreExamples() {
        return this.presentlyProcessed.size() > 0;
    }

    public int howManyExamplesLeft() {
        return this.presentlyProcessed.size();
    }

    public void refreshDataset() {
        this.presentlyProcessed = new ArrayList<NNExample>();
        for (NNExample e : this.dataset) {
            this.presentlyProcessed.add(e.copyExample());
        }
    }

    public void createExamplesFromFile(String filename) throws Exception {
        this.createNormalizedDataFromFile(filename);
        this.setTargetColumns();
        this.createExamples();
    }

    public void createExamplesFromDataSet(DataSet ds, Numerizer numerizer) throws Exception {
        this.createNormalizedDataFromDataSet(ds, numerizer);
        this.setTargetColumns();
        this.createExamples();
    }

    public List<List<Double>> getNormalizedData() {
        return this.nds;
    }

    public List<Double> getMeans() {
        return this.means;
    }

    public List<Double> getStdevs() {
        return this.stdevs;
    }

    private void createExamples() {
        this.dataset = new ArrayList<NNExample>();
        for (List<Double> dataLine : this.nds) {
            ArrayList<Double> input = new ArrayList<Double>();
            ArrayList<Double> target = new ArrayList<Double>();
            for (int i = 0; i < dataLine.size(); ++i) {
                if (this.targetColumnNumbers.contains(i)) {
                    target.add(dataLine.get(i));
                    continue;
                }
                input.add(dataLine.get(i));
            }
            this.dataset.add(new NNExample(input, target));
        }
        this.refreshDataset();
    }

    private List<List<Double>> normalize(List<List<Double>> rds) {
        int rawDataLength = rds.get(0).size();
        ArrayList<List<Double>> nds = new ArrayList<List<Double>>();
        this.means = new ArrayList<Double>();
        this.stdevs = new ArrayList<Double>();
        ArrayList<List<Double>> normalizedColumns = new ArrayList<List<Double>>();
        for (int i = 0; i < rawDataLength; ++i) {
            ArrayList<Double> columnValues = new ArrayList<Double>();
            for (List<Double> rawDatum : rds) {
                columnValues.add(rawDatum.get(i));
            }
            double mean = Util.calculateMean(columnValues);
            this.means.add(mean);
            double stdev = Util.calculateStDev(columnValues, mean);
            this.stdevs.add(stdev);
            normalizedColumns.add(Util.normalizeFromMeanAndStdev(columnValues, mean, stdev));
        }
        int columnLength = ((List)normalizedColumns.get(0)).size();
        int numberOfColumns = normalizedColumns.size();
        for (int i = 0; i < columnLength; ++i) {
            ArrayList lst = new ArrayList();
            for (int j = 0; j < numberOfColumns; ++j) {
                lst.add(((List)normalizedColumns.get(j)).get(i));
            }
            nds.add(lst);
        }
        return nds;
    }

    private List<Double> exampleFromString(String line, String separator) {
        ArrayList<Double> rexample = new ArrayList<Double>();
        List<String> attributeValues = Arrays.asList(line.split(separator));
        for (String valString : attributeValues) {
            rexample.add(Double.parseDouble(valString));
        }
        return rexample;
    }

    private List<List<Double>> rawExamplesFromDataSet(DataSet ds, Numerizer numerizer) {
        ArrayList<List<Double>> rds = new ArrayList<List<Double>>();
        for (int i = 0; i < ds.size(); ++i) {
            ArrayList<Double> rexample = new ArrayList<Double>();
            Example e = ds.getExample(i);
            Pair<List<Double>, List<Double>> p = numerizer.numerize(e);
            List<Double> attributes = p.getFirst();
            for (Double d : attributes) {
                rexample.add(d);
            }
            List<Double> targets = p.getSecond();
            for (Double d : targets) {
                rexample.add(d);
            }
            rds.add(rexample);
        }
        return rds;
    }
}

