/*
 * Decompiled with CFR 0.152.
 */
package aima.core.learning.neural;

import aima.core.learning.neural.Layer;
import aima.core.util.math.Matrix;
import aima.core.util.math.Vector;
import java.util.ArrayList;

public class LayerSensitivity {
    private Matrix sensitivityMatrix;
    private final Layer layer;

    public LayerSensitivity(Layer layer) {
        Matrix weightMatrix = layer.getWeightMatrix();
        this.sensitivityMatrix = new Matrix(weightMatrix.getRowDimension(), weightMatrix.getColumnDimension());
        this.layer = layer;
    }

    public Matrix getSensitivityMatrix() {
        return this.sensitivityMatrix;
    }

    public Matrix sensitivityMatrixFromErrorMatrix(Vector errorVector) {
        Matrix derivativeMatrix = this.createDerivativeMatrix(this.layer.getLastInducedField());
        Matrix calculatedSensitivityMatrix = derivativeMatrix.times(errorVector).times(-2.0);
        this.sensitivityMatrix = calculatedSensitivityMatrix.copy();
        return calculatedSensitivityMatrix;
    }

    public Matrix sensitivityMatrixFromSucceedingLayer(LayerSensitivity nextLayerSensitivity) {
        Layer nextLayer = nextLayerSensitivity.getLayer();
        Matrix derivativeMatrix = this.createDerivativeMatrix(this.layer.getLastInducedField());
        Matrix weightTranspose = nextLayer.getWeightMatrix().transpose();
        Matrix calculatedSensitivityMatrix = derivativeMatrix.times(weightTranspose).times(nextLayerSensitivity.getSensitivityMatrix());
        this.sensitivityMatrix = calculatedSensitivityMatrix.copy();
        return this.sensitivityMatrix;
    }

    public Layer getLayer() {
        return this.layer;
    }

    private Matrix createDerivativeMatrix(Vector lastInducedField) {
        ArrayList<Double> lst = new ArrayList<Double>();
        for (int i = 0; i < lastInducedField.size(); ++i) {
            lst.add(new Double(this.layer.getActivationFunction().deriv(lastInducedField.getValue(i))));
        }
        return Matrix.createDiagonalMatrix(lst);
    }
}

