/*
 * Decompiled with CFR 0.152.
 */
package aima.core.learning.knowledge;

import aima.core.learning.framework.DataSetSpecification;
import aima.core.logic.fol.domain.FOLDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class FOLDataSetDomain
extends FOLDomain {
    private static Pattern allowableCharactersRegEx = Pattern.compile("[^a-zA-Z_$0-9]");
    private DataSetSpecification dataSetSpecification;
    private String trueGoalValue = null;
    private String examplePrefix = "X";
    private List<String> descriptionPredicateNames = new ArrayList<String>();
    private List<String> descriptionDataSetNames = new ArrayList<String>();
    private Map<String, String> dsToFOLNameMap = new HashMap<String, String>();

    public FOLDataSetDomain(DataSetSpecification dataSetSpecification, String trueGoalValue) {
        this.dataSetSpecification = dataSetSpecification;
        this.trueGoalValue = trueGoalValue;
        this.constructFOLDomain();
    }

    public String getDataSetTargetName() {
        return this.dataSetSpecification.getTarget();
    }

    public String getGoalPredicateName() {
        return this.getFOLName(this.dataSetSpecification.getTarget());
    }

    public String getTrueGoalValue() {
        return this.trueGoalValue;
    }

    public List<String> getDescriptionPredicateNames() {
        return this.descriptionPredicateNames;
    }

    public List<String> getDescriptionDataSetNames() {
        return this.descriptionDataSetNames;
    }

    public boolean isMultivalued(String descriptiveDataSetName) {
        List<String> possibleValues = this.dataSetSpecification.getPossibleAttributeValues(descriptiveDataSetName);
        if (possibleValues.size() > 2) {
            return true;
        }
        for (String pv : possibleValues) {
            if (!this.trueGoalValue.equals(pv)) continue;
            return false;
        }
        return true;
    }

    public String getExampleConstant(int egNo) {
        String egConstant = this.examplePrefix + egNo;
        this.addConstant(egConstant);
        return egConstant;
    }

    public String getFOLName(String dsName) {
        String folName = this.dsToFOLNameMap.get(dsName);
        if (null == folName) {
            folName = dsName;
            if (!Character.isJavaIdentifierStart(dsName.charAt(0))) {
                folName = "_" + dsName;
            }
            folName = allowableCharactersRegEx.matcher(folName).replaceAll("_");
            this.dsToFOLNameMap.put(dsName, folName);
        }
        return folName;
    }

    private void constructFOLDomain() {
        this.addPredicate(this.getFOLName(this.dataSetSpecification.getTarget()));
        for (String saName : this.dataSetSpecification.getNamesOfStringAttributes()) {
            if (this.dataSetSpecification.getTarget().equals(saName)) continue;
            String folSAName = this.getFOLName(saName);
            this.addPredicate(folSAName);
            this.descriptionPredicateNames.add(folSAName);
            this.descriptionDataSetNames.add(saName);
            List<String> attributeValues = this.dataSetSpecification.getPossibleAttributeValues(saName);
            if (!this.isMultivalued(saName)) continue;
            for (String av : attributeValues) {
                this.addConstant(this.getFOLName(av));
            }
        }
    }
}

