/*
 * Decompiled with CFR 0.152.
 */
package aima.core.learning.inductive;

import aima.core.learning.framework.DataSet;
import aima.core.learning.framework.Example;
import aima.core.learning.inductive.ConstantDecisonTree;
import aima.core.util.Util;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class DecisionTree {
    private String attributeName;
    private Hashtable<String, DecisionTree> nodes;

    protected DecisionTree() {
    }

    public DecisionTree(String attributeName) {
        this.attributeName = attributeName;
        this.nodes = new Hashtable();
    }

    public void addLeaf(String attributeValue, String decision) {
        this.nodes.put(attributeValue, new ConstantDecisonTree(decision));
    }

    public void addNode(String attributeValue, DecisionTree tree) {
        this.nodes.put(attributeValue, tree);
    }

    public Object predict(Example e) {
        String attrValue = e.getAttributeValueAsString(this.attributeName);
        if (this.nodes.containsKey(attrValue)) {
            return this.nodes.get(attrValue).predict(e);
        }
        throw new RuntimeException("no node exists for attribute value " + attrValue);
    }

    public static DecisionTree getStumpFor(DataSet ds, String attributeName, String attributeValue, String returnValueIfMatched, List<String> unmatchedValues, String returnValueIfUnmatched) {
        DecisionTree dt = new DecisionTree(attributeName);
        dt.addLeaf(attributeValue, returnValueIfMatched);
        for (String unmatchedValue : unmatchedValues) {
            dt.addLeaf(unmatchedValue, returnValueIfUnmatched);
        }
        return dt;
    }

    public static List<DecisionTree> getStumpsFor(DataSet ds, String returnValueIfMatched, String returnValueIfUnmatched) {
        List<String> attributes = ds.getNonTargetAttributes();
        ArrayList<DecisionTree> trees = new ArrayList<DecisionTree>();
        for (String attribute : attributes) {
            List<String> values = ds.getPossibleAttributeValues(attribute);
            for (String value : values) {
                List<String> unmatchedValues = Util.removeFrom(ds.getPossibleAttributeValues(attribute), value);
                DecisionTree tree = DecisionTree.getStumpFor(ds, attribute, value, returnValueIfMatched, unmatchedValues, returnValueIfUnmatched);
                trees.add(tree);
            }
        }
        return trees;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String toString() {
        return this.toString(1, new StringBuffer());
    }

    public String toString(int depth, StringBuffer buf) {
        if (this.attributeName != null) {
            buf.append(Util.ntimes("\t", depth));
            buf.append(Util.ntimes("***", 1));
            buf.append(this.attributeName + " \n");
            for (String attributeValue : this.nodes.keySet()) {
                buf.append(Util.ntimes("\t", depth + 1));
                buf.append("+" + attributeValue);
                buf.append("\n");
                DecisionTree child = this.nodes.get(attributeValue);
                buf.append(child.toString(depth + 1, new StringBuffer()));
            }
        }
        return buf.toString();
    }
}

