/*
 * Decompiled with CFR 0.152.
 */
package aima.core.learning.inductive;

import aima.core.learning.framework.Example;
import aima.core.learning.inductive.DLTest;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class DecisionList {
    private String positive;
    private String negative;
    private List<DLTest> tests;
    private Hashtable<DLTest, String> testOutcomes;

    public DecisionList(String positive, String negative) {
        this.positive = positive;
        this.negative = negative;
        this.tests = new ArrayList<DLTest>();
        this.testOutcomes = new Hashtable();
    }

    public String predict(Example example) {
        if (this.tests.size() == 0) {
            return this.negative;
        }
        for (DLTest test : this.tests) {
            if (!test.matches(example)) continue;
            return this.testOutcomes.get(test);
        }
        return this.negative;
    }

    public void add(DLTest test, String outcome) {
        this.tests.add(test);
        this.testOutcomes.put(test, outcome);
    }

    public DecisionList mergeWith(DecisionList dlist2) {
        DecisionList merged = new DecisionList(this.positive, this.negative);
        for (DLTest test : this.tests) {
            merged.add(test, this.testOutcomes.get(test));
        }
        for (DLTest test : dlist2.tests) {
            merged.add(test, dlist2.testOutcomes.get(test));
        }
        return merged;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (DLTest test : this.tests) {
            buf.append(test.toString() + " => " + this.testOutcomes.get(test) + " ELSE \n");
        }
        buf.append("END");
        return buf.toString();
    }
}

