/*
 * Decompiled with CFR 0.152.
 */
package aima.core.learning.framework;

import aima.core.learning.data.DataResource;
import aima.core.learning.framework.Attribute;
import aima.core.learning.framework.AttributeSpecification;
import aima.core.learning.framework.DataSet;
import aima.core.learning.framework.DataSetSpecification;
import aima.core.learning.framework.Example;
import aima.core.util.Util;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class DataSetFactory {
    public DataSet fromFile(String filename, DataSetSpecification spec, String separator) throws Exception {
        String line;
        DataSet ds = new DataSet(spec);
        BufferedReader reader = new BufferedReader(new InputStreamReader(DataResource.class.getResourceAsStream(filename + ".csv")));
        while ((line = reader.readLine()) != null) {
            ds.add(DataSetFactory.exampleFromString(line, spec, separator));
        }
        return ds;
    }

    public static Example exampleFromString(String data, DataSetSpecification dataSetSpec, String separator) {
        Hashtable<String, Attribute> attributes = new Hashtable<String, Attribute>();
        List<String> attributeValues = Arrays.asList(data.split(separator));
        if (dataSetSpec.isValid(attributeValues)) {
            List<String> names = dataSetSpec.getAttributeNames();
            Iterator<String> nameiter = names.iterator();
            Iterator<String> valueiter = attributeValues.iterator();
            while (nameiter.hasNext() && valueiter.hasNext()) {
                String name = nameiter.next();
                AttributeSpecification attributeSpec = dataSetSpec.getAttributeSpecFor(name);
                Attribute attribute = attributeSpec.createAttribute(valueiter.next());
                attributes.put(name, attribute);
            }
            String targetAttributeName = dataSetSpec.getTarget();
            return new Example(attributes, (Attribute)attributes.get(targetAttributeName));
        }
        throw new RuntimeException("Unable to construct Example from " + data);
    }

    public static DataSet getRestaurantDataSet() throws Exception {
        DataSetSpecification spec = DataSetFactory.createRestaurantDataSetSpec();
        return new DataSetFactory().fromFile("restaurant", spec, "\\s+");
    }

    public static DataSetSpecification createRestaurantDataSetSpec() {
        DataSetSpecification dss = new DataSetSpecification();
        dss.defineStringAttribute("alternate", Util.yesno());
        dss.defineStringAttribute("bar", Util.yesno());
        dss.defineStringAttribute("fri/sat", Util.yesno());
        dss.defineStringAttribute("hungry", Util.yesno());
        dss.defineStringAttribute("patrons", new String[]{"None", "Some", "Full"});
        dss.defineStringAttribute("price", new String[]{"$", "$$", "$$$"});
        dss.defineStringAttribute("raining", Util.yesno());
        dss.defineStringAttribute("reservation", Util.yesno());
        dss.defineStringAttribute("type", new String[]{"French", "Italian", "Thai", "Burger"});
        dss.defineStringAttribute("wait_estimate", new String[]{"0-10", "10-30", "30-60", ">60"});
        dss.defineStringAttribute("will_wait", Util.yesno());
        return dss;
    }

    public static DataSet getIrisDataSet() throws Exception {
        DataSetSpecification spec = DataSetFactory.createIrisDataSetSpec();
        return new DataSetFactory().fromFile("iris", spec, ",");
    }

    public static DataSetSpecification createIrisDataSetSpec() {
        DataSetSpecification dss = new DataSetSpecification();
        dss.defineNumericAttribute("sepal_length");
        dss.defineNumericAttribute("sepal_width");
        dss.defineNumericAttribute("petal_length");
        dss.defineNumericAttribute("petal_width");
        dss.defineStringAttribute("plant_category", new String[]{"setosa", "versicolor", "virginica"});
        return dss;
    }
}

