/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.xyenv;

import aima.core.agent.Agent;
import aima.core.agent.EnvironmentObject;
import aima.core.agent.EnvironmentState;
import aima.core.util.datastructure.XYLocation;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

class XYEnvironmentState
implements EnvironmentState {
    int width;
    int height;
    private Map<XYLocation, Set<EnvironmentObject>> objsAtLocation = new LinkedHashMap<XYLocation, Set<EnvironmentObject>>();

    public XYEnvironmentState(int width, int height) {
        this.width = width;
        this.height = height;
        for (int h = 1; h <= height; ++h) {
            for (int w = 1; w <= width; ++w) {
                this.objsAtLocation.put(new XYLocation(h, w), new LinkedHashSet());
            }
        }
    }

    public void moveObjectToAbsoluteLocation(EnvironmentObject eo, XYLocation loc) {
        for (Set<EnvironmentObject> eos : this.objsAtLocation.values()) {
            if (eos.remove(eo)) break;
        }
        this.getObjectsAt(loc).add(eo);
    }

    public Set<EnvironmentObject> getObjectsAt(XYLocation loc) {
        Set<EnvironmentObject> objectsAt = this.objsAtLocation.get(loc);
        if (null == objectsAt) {
            objectsAt = new LinkedHashSet<EnvironmentObject>();
            this.objsAtLocation.put(loc, objectsAt);
        }
        return objectsAt;
    }

    public XYLocation getCurrentLocationFor(EnvironmentObject eo) {
        for (XYLocation loc : this.objsAtLocation.keySet()) {
            if (!this.objsAtLocation.get(loc).contains(eo)) continue;
            return loc;
        }
        return null;
    }

    public Set<EnvironmentObject> getObjectsNear(Agent agent, int radius) {
        LinkedHashSet<EnvironmentObject> objsNear = new LinkedHashSet<EnvironmentObject>();
        XYLocation agentLocation = this.getCurrentLocationFor(agent);
        for (XYLocation loc : this.objsAtLocation.keySet()) {
            if (!this.withinRadius(radius, agentLocation, loc)) continue;
            objsNear.addAll((Collection<EnvironmentObject>)this.objsAtLocation.get(loc));
        }
        objsNear.remove(agent);
        return objsNear;
    }

    public String toString() {
        return "XYEnvironmentState:" + this.objsAtLocation.toString();
    }

    private boolean withinRadius(int radius, XYLocation agentLocation, XYLocation objectLocation) {
        int ydifference;
        int xdifference = agentLocation.getXCoOrdinate() - objectLocation.getXCoOrdinate();
        return Math.sqrt(xdifference * xdifference + (ydifference = agentLocation.getYCoOrdinate() - objectLocation.getYCoOrdinate()) * ydifference) <= (double)radius;
    }
}

