/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.xyenv;

import aima.core.agent.Action;
import aima.core.agent.Agent;
import aima.core.agent.EnvironmentObject;
import aima.core.agent.Percept;
import aima.core.agent.impl.AbstractEnvironment;
import aima.core.agent.impl.DynamicPercept;
import aima.core.environment.xyenv.Wall;
import aima.core.environment.xyenv.XYEnvironmentState;
import aima.core.util.datastructure.XYLocation;
import java.util.Set;

public class XYEnvironment
extends AbstractEnvironment {
    private XYEnvironmentState envState = null;

    public XYEnvironment(int width, int height) {
        assert (width > 0);
        assert (height > 0);
        this.envState = new XYEnvironmentState(width, height);
    }

    @Override
    public void executeAction(Agent a, Action action) {
    }

    @Override
    public Percept getPerceptSeenBy(Agent anAgent) {
        return new DynamicPercept();
    }

    public void addObjectToLocation(EnvironmentObject eo, XYLocation loc) {
        this.moveObjectToAbsoluteLocation(eo, loc);
    }

    public void moveObjectToAbsoluteLocation(EnvironmentObject eo, XYLocation loc) {
        this.envState.moveObjectToAbsoluteLocation(eo, loc);
        this.addEnvironmentObject(eo);
    }

    public void moveObject(EnvironmentObject eo, XYLocation.Direction direction) {
        XYLocation locationToMoveTo;
        XYLocation presentLocation = this.envState.getCurrentLocationFor(eo);
        if (null != presentLocation && !this.isBlocked(locationToMoveTo = presentLocation.locationAt(direction))) {
            this.moveObjectToAbsoluteLocation(eo, locationToMoveTo);
        }
    }

    public XYLocation getCurrentLocationFor(EnvironmentObject eo) {
        return this.envState.getCurrentLocationFor(eo);
    }

    public Set<EnvironmentObject> getObjectsAt(XYLocation loc) {
        return this.envState.getObjectsAt(loc);
    }

    public Set<EnvironmentObject> getObjectsNear(Agent agent, int radius) {
        return this.envState.getObjectsNear(agent, radius);
    }

    public boolean isBlocked(XYLocation loc) {
        for (EnvironmentObject eo : this.envState.getObjectsAt(loc)) {
            if (!(eo instanceof Wall)) continue;
            return true;
        }
        return false;
    }

    public void makePerimeter() {
        XYLocation loc2;
        XYLocation loc;
        int i;
        for (i = 0; i < this.envState.width; ++i) {
            loc = new XYLocation(i, 0);
            loc2 = new XYLocation(i, this.envState.height - 1);
            this.envState.moveObjectToAbsoluteLocation(new Wall(), loc);
            this.envState.moveObjectToAbsoluteLocation(new Wall(), loc2);
        }
        for (i = 0; i < this.envState.height; ++i) {
            loc = new XYLocation(0, i);
            loc2 = new XYLocation(this.envState.width - 1, i);
            this.envState.moveObjectToAbsoluteLocation(new Wall(), loc);
            this.envState.moveObjectToAbsoluteLocation(new Wall(), loc2);
        }
    }
}

