/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.wumpusworld;

import aima.core.agent.Action;
import aima.core.environment.wumpusworld.AgentPercept;
import aima.core.environment.wumpusworld.AgentPosition;
import aima.core.environment.wumpusworld.Room;
import aima.core.environment.wumpusworld.action.Climb;
import aima.core.environment.wumpusworld.action.Forward;
import aima.core.environment.wumpusworld.action.Grab;
import aima.core.environment.wumpusworld.action.Shoot;
import aima.core.environment.wumpusworld.action.TurnLeft;
import aima.core.environment.wumpusworld.action.TurnRight;
import aima.core.logic.propositional.inference.DPLL;
import aima.core.logic.propositional.inference.OptimizedDPLL;
import aima.core.logic.propositional.kb.KnowledgeBase;
import aima.core.logic.propositional.parsing.ast.ComplexSentence;
import aima.core.logic.propositional.parsing.ast.Connective;
import aima.core.logic.propositional.parsing.ast.PropositionSymbol;
import aima.core.logic.propositional.parsing.ast.Sentence;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class WumpusKnowledgeBase
extends KnowledgeBase {
    public static final String LOCATION = "L";
    public static final String BREEZE = "B";
    public static final String STENCH = "S";
    public static final String PIT = "P";
    public static final String WUMPUS = "W";
    public static final String WUMPUS_ALIVE = "WumpusAlive";
    public static final String HAVE_ARROW = "HaveArrow";
    public static final String FACING_NORTH = AgentPosition.Orientation.FACING_NORTH.toString();
    public static final String FACING_SOUTH = AgentPosition.Orientation.FACING_SOUTH.toString();
    public static final String FACING_EAST = AgentPosition.Orientation.FACING_EAST.toString();
    public static final String FACING_WEST = AgentPosition.Orientation.FACING_WEST.toString();
    public static final String PERCEPT_STENCH = "Stench";
    public static final String PERCEPT_BREEZE = "Breeze";
    public static final String PERCEPT_GLITTER = "Glitter";
    public static final String PERCEPT_BUMP = "Bump";
    public static final String PERCEPT_SCREAM = "Scream";
    public static final String ACTION_FORWARD = "Forward";
    public static final String ACTION_SHOOT = "Shoot";
    public static final String ACTION_TURN_LEFT = "TurnLeft";
    public static final String ACTION_TURN_RIGHT = "TurnRight";
    public static final String OK_TO_MOVE_INTO = "OK";
    private int caveXDimension;
    private int caveYDimension;
    private DPLL dpll;

    public WumpusKnowledgeBase(int caveXandYDimensions) {
        this(new OptimizedDPLL(), caveXandYDimensions);
    }

    public WumpusKnowledgeBase(DPLL dpll, int caveXandYDimensions) {
        int x;
        this.dpll = dpll;
        this.caveXDimension = caveXandYDimensions;
        this.caveYDimension = caveXandYDimensions;
        this.tell(new ComplexSentence(Connective.NOT, this.newSymbol(PIT, 1, 1)));
        this.tell(new ComplexSentence(Connective.NOT, this.newSymbol(WUMPUS, 1, 1)));
        for (int y = 1; y <= this.caveYDimension; ++y) {
            for (x = 1; x <= this.caveXDimension; ++x) {
                ArrayList<PropositionSymbol> pitsIn = new ArrayList<PropositionSymbol>();
                ArrayList<PropositionSymbol> wumpsIn = new ArrayList<PropositionSymbol>();
                if (x > 1) {
                    pitsIn.add(this.newSymbol(PIT, x - 1, y));
                    wumpsIn.add(this.newSymbol(WUMPUS, x - 1, y));
                }
                if (y < this.caveYDimension) {
                    pitsIn.add(this.newSymbol(PIT, x, y + 1));
                    wumpsIn.add(this.newSymbol(WUMPUS, x, y + 1));
                }
                if (x < this.caveXDimension) {
                    pitsIn.add(this.newSymbol(PIT, x + 1, y));
                    wumpsIn.add(this.newSymbol(WUMPUS, x + 1, y));
                }
                if (y > 1) {
                    pitsIn.add(this.newSymbol(PIT, x, y - 1));
                    wumpsIn.add(this.newSymbol(WUMPUS, x, y - 1));
                }
                this.tell(new ComplexSentence(this.newSymbol(BREEZE, x, y), Connective.BICONDITIONAL, Sentence.newDisjunction(pitsIn)));
                this.tell(new ComplexSentence(this.newSymbol(STENCH, x, y), Connective.BICONDITIONAL, Sentence.newDisjunction(wumpsIn)));
            }
        }
        ArrayList<PropositionSymbol> wumpsAtLeast = new ArrayList<PropositionSymbol>();
        for (x = 1; x <= this.caveXDimension; ++x) {
            for (int y = 1; y <= this.caveYDimension; ++y) {
                wumpsAtLeast.add(this.newSymbol(WUMPUS, x, y));
            }
        }
        this.tell(Sentence.newDisjunction(wumpsAtLeast));
        int numRooms = this.caveXDimension * this.caveYDimension;
        for (int i = 0; i < numRooms; ++i) {
            for (int j = i + 1; j < numRooms; ++j) {
                this.tell(new ComplexSentence(Connective.OR, new ComplexSentence(Connective.NOT, this.newSymbol(WUMPUS, i / this.caveXDimension + 1, i % this.caveYDimension + 1)), new ComplexSentence(Connective.NOT, this.newSymbol(WUMPUS, j / this.caveXDimension + 1, j % this.caveYDimension + 1))));
            }
        }
    }

    public AgentPosition askCurrentPosition(int t) {
        int locX = -1;
        int locY = -1;
        for (int x = 1; x <= this.getCaveXDimension() && locX == -1; ++x) {
            for (int y = 1; y <= this.getCaveYDimension() && locY == -1; ++y) {
                if (!this.ask(this.newSymbol(LOCATION, t, x, y))) continue;
                locX = x;
                locY = y;
            }
        }
        if (locX == -1 || locY == -1) {
            throw new IllegalStateException("Inconsistent KB, unable to determine current room position.");
        }
        AgentPosition current = null;
        if (this.ask(this.newSymbol(FACING_NORTH, t))) {
            current = new AgentPosition(locX, locY, AgentPosition.Orientation.FACING_NORTH);
        } else if (this.ask(this.newSymbol(FACING_SOUTH, t))) {
            current = new AgentPosition(locX, locY, AgentPosition.Orientation.FACING_SOUTH);
        } else if (this.ask(this.newSymbol(FACING_EAST, t))) {
            current = new AgentPosition(locX, locY, AgentPosition.Orientation.FACING_EAST);
        } else if (this.ask(this.newSymbol(FACING_WEST, t))) {
            current = new AgentPosition(locX, locY, AgentPosition.Orientation.FACING_WEST);
        } else {
            throw new IllegalStateException("Inconsistent KB, unable to determine current room orientation.");
        }
        return current;
    }

    public Set<Room> askSafeRooms(int t) {
        LinkedHashSet<Room> safe = new LinkedHashSet<Room>();
        for (int x = 1; x <= this.getCaveXDimension(); ++x) {
            for (int y = 1; y <= this.getCaveYDimension(); ++y) {
                if (!this.ask(this.newSymbol(OK_TO_MOVE_INTO, t, x, y))) continue;
                safe.add(new Room(x, y));
            }
        }
        return safe;
    }

    public boolean askGlitter(int t) {
        return this.ask(this.newSymbol(PERCEPT_GLITTER, t));
    }

    public Set<Room> askUnvisitedRooms(int t) {
        LinkedHashSet<Room> unvisited = new LinkedHashSet<Room>();
        for (int x = 1; x <= this.getCaveXDimension(); ++x) {
            for (int y = 1; y <= this.getCaveYDimension(); ++y) {
                for (int tPrime = 0; tPrime <= t && !this.ask(this.newSymbol(LOCATION, tPrime, x, y)); ++tPrime) {
                    if (tPrime != t) continue;
                    unvisited.add(new Room(x, y));
                }
            }
        }
        return unvisited;
    }

    public boolean askHaveArrow(int t) {
        return this.ask(this.newSymbol(HAVE_ARROW, t));
    }

    public Set<Room> askPossibleWumpusRooms(int t) {
        LinkedHashSet<Room> possible = new LinkedHashSet<Room>();
        for (int x = 1; x <= this.getCaveXDimension(); ++x) {
            for (int y = 1; y <= this.getCaveYDimension(); ++y) {
                if (this.ask(new ComplexSentence(Connective.NOT, this.newSymbol(WUMPUS, x, y)))) continue;
                possible.add(new Room(x, y));
            }
        }
        return possible;
    }

    public Set<Room> askNotUnsafeRooms(int t) {
        LinkedHashSet<Room> notUnsafe = new LinkedHashSet<Room>();
        for (int x = 1; x <= this.getCaveXDimension(); ++x) {
            for (int y = 1; y <= this.getCaveYDimension(); ++y) {
                if (this.ask(new ComplexSentence(Connective.NOT, this.newSymbol(OK_TO_MOVE_INTO, t, x, y)))) continue;
                notUnsafe.add(new Room(x, y));
            }
        }
        return notUnsafe;
    }

    public boolean askOK(int t, int x, int y) {
        return this.ask(this.newSymbol(OK_TO_MOVE_INTO, t, x, y));
    }

    public boolean ask(Sentence query) {
        return this.dpll.isEntailed(this, query);
    }

    public int getCaveXDimension() {
        return this.caveXDimension;
    }

    public void setCaveXDimension(int caveXDimension) {
        this.caveXDimension = caveXDimension;
    }

    public int getCaveYDimension() {
        return this.caveYDimension;
    }

    public void setCaveYDimension(int caveYDimension) {
        this.caveYDimension = caveYDimension;
    }

    public void makeActionSentence(Action a, int t) {
        if (a instanceof Climb) {
            this.tell(this.newSymbol("Climb", t));
        } else {
            this.tell(new ComplexSentence(Connective.NOT, this.newSymbol("Climb", t)));
        }
        if (a instanceof Forward) {
            this.tell(this.newSymbol(ACTION_FORWARD, t));
        } else {
            this.tell(new ComplexSentence(Connective.NOT, this.newSymbol(ACTION_FORWARD, t)));
        }
        if (a instanceof Grab) {
            this.tell(this.newSymbol("Grab", t));
        } else {
            this.tell(new ComplexSentence(Connective.NOT, this.newSymbol("Grab", t)));
        }
        if (a instanceof Shoot) {
            this.tell(this.newSymbol(ACTION_SHOOT, t));
        } else {
            this.tell(new ComplexSentence(Connective.NOT, this.newSymbol(ACTION_SHOOT, t)));
        }
        if (a instanceof TurnLeft) {
            this.tell(this.newSymbol(ACTION_TURN_LEFT, t));
        } else {
            this.tell(new ComplexSentence(Connective.NOT, this.newSymbol(ACTION_TURN_LEFT, t)));
        }
        if (a instanceof TurnRight) {
            this.tell(this.newSymbol(ACTION_TURN_RIGHT, t));
        } else {
            this.tell(new ComplexSentence(Connective.NOT, this.newSymbol(ACTION_TURN_RIGHT, t)));
        }
    }

    public void makePerceptSentence(AgentPercept p, int time) {
        if (p.isStench()) {
            this.tell(this.newSymbol(PERCEPT_STENCH, time));
        } else {
            this.tell(new ComplexSentence(Connective.NOT, this.newSymbol(PERCEPT_STENCH, time)));
        }
        if (p.isBreeze()) {
            this.tell(this.newSymbol(PERCEPT_BREEZE, time));
        } else {
            this.tell(new ComplexSentence(Connective.NOT, this.newSymbol(PERCEPT_BREEZE, time)));
        }
        if (p.isGlitter()) {
            this.tell(this.newSymbol(PERCEPT_GLITTER, time));
        } else {
            this.tell(new ComplexSentence(Connective.NOT, this.newSymbol(PERCEPT_GLITTER, time)));
        }
        if (p.isBump()) {
            this.tell(this.newSymbol(PERCEPT_BUMP, time));
        } else {
            this.tell(new ComplexSentence(Connective.NOT, this.newSymbol(PERCEPT_BUMP, time)));
        }
        if (p.isScream()) {
            this.tell(this.newSymbol(PERCEPT_SCREAM, time));
        } else {
            this.tell(new ComplexSentence(Connective.NOT, this.newSymbol(PERCEPT_SCREAM, time)));
        }
    }

    public void tellTemporalPhysicsSentences(int t) {
        int y;
        int x;
        if (t == 0) {
            this.tell(this.newSymbol(LOCATION, 0, 1, 1));
            this.tell(this.newSymbol(FACING_EAST, 0));
            this.tell(this.newSymbol(HAVE_ARROW, 0));
            this.tell(this.newSymbol(WUMPUS_ALIVE, 0));
        }
        for (x = 1; x <= this.caveXDimension; ++x) {
            for (y = 1; y <= this.caveYDimension; ++y) {
                this.tell(new ComplexSentence(this.newSymbol(LOCATION, t, x, y), Connective.IMPLICATION, (Sentence)new ComplexSentence(this.newSymbol(PERCEPT_BREEZE, t), Connective.BICONDITIONAL, (Sentence)this.newSymbol(BREEZE, x, y))));
                this.tell(new ComplexSentence(this.newSymbol(LOCATION, t, x, y), Connective.IMPLICATION, (Sentence)new ComplexSentence(this.newSymbol(PERCEPT_STENCH, t), Connective.BICONDITIONAL, (Sentence)this.newSymbol(STENCH, x, y))));
            }
        }
        for (x = 1; x <= this.caveXDimension; ++x) {
            for (y = 1; y <= this.caveYDimension; ++y) {
                ArrayList<ComplexSentence> locDisjuncts = new ArrayList<ComplexSentence>();
                locDisjuncts.add(new ComplexSentence(this.newSymbol(LOCATION, t, x, y), Connective.AND, (Sentence)new ComplexSentence(new ComplexSentence(Connective.NOT, this.newSymbol(ACTION_FORWARD, t)), Connective.OR, (Sentence)this.newSymbol(PERCEPT_BUMP, t + 1))));
                if (x > 1) {
                    locDisjuncts.add(new ComplexSentence(this.newSymbol(LOCATION, t, x - 1, y), Connective.AND, (Sentence)new ComplexSentence(this.newSymbol(FACING_EAST, t), Connective.AND, (Sentence)this.newSymbol(ACTION_FORWARD, t))));
                }
                if (y < this.caveYDimension) {
                    locDisjuncts.add(new ComplexSentence(this.newSymbol(LOCATION, t, x, y + 1), Connective.AND, (Sentence)new ComplexSentence(this.newSymbol(FACING_SOUTH, t), Connective.AND, (Sentence)this.newSymbol(ACTION_FORWARD, t))));
                }
                if (x < this.caveXDimension) {
                    locDisjuncts.add(new ComplexSentence(this.newSymbol(LOCATION, t, x + 1, y), Connective.AND, (Sentence)new ComplexSentence(this.newSymbol(FACING_WEST, t), Connective.AND, (Sentence)this.newSymbol(ACTION_FORWARD, t))));
                }
                if (y > 1) {
                    locDisjuncts.add(new ComplexSentence(this.newSymbol(LOCATION, t, x, y - 1), Connective.AND, (Sentence)new ComplexSentence(this.newSymbol(FACING_NORTH, t), Connective.AND, (Sentence)this.newSymbol(ACTION_FORWARD, t))));
                }
                this.tell(new ComplexSentence(this.newSymbol(LOCATION, t + 1, x, y), Connective.BICONDITIONAL, Sentence.newDisjunction(locDisjuncts)));
                this.tell(new ComplexSentence(this.newSymbol(OK_TO_MOVE_INTO, t, x, y), Connective.BICONDITIONAL, (Sentence)new ComplexSentence(new ComplexSentence(Connective.NOT, this.newSymbol(PIT, x, y)), Connective.AND, (Sentence)new ComplexSentence(Connective.NOT, new ComplexSentence(this.newSymbol(WUMPUS, x, y), Connective.AND, (Sentence)this.newSymbol(WUMPUS_ALIVE, t))))));
            }
        }
        this.tell(new ComplexSentence(this.newSymbol(FACING_NORTH, t + 1), Connective.BICONDITIONAL, Sentence.newDisjunction(new ComplexSentence(this.newSymbol(FACING_WEST, t), Connective.AND, (Sentence)this.newSymbol(ACTION_TURN_RIGHT, t)), new ComplexSentence(this.newSymbol(FACING_EAST, t), Connective.AND, (Sentence)this.newSymbol(ACTION_TURN_LEFT, t)), new ComplexSentence(this.newSymbol(FACING_NORTH, t), Connective.AND, (Sentence)new ComplexSentence(new ComplexSentence(Connective.NOT, this.newSymbol(ACTION_TURN_LEFT, t)), Connective.AND, (Sentence)new ComplexSentence(Connective.NOT, this.newSymbol(ACTION_TURN_RIGHT, t)))))));
        this.tell(new ComplexSentence(this.newSymbol(FACING_SOUTH, t + 1), Connective.BICONDITIONAL, Sentence.newDisjunction(new ComplexSentence(this.newSymbol(FACING_WEST, t), Connective.AND, (Sentence)this.newSymbol(ACTION_TURN_LEFT, t)), new ComplexSentence(this.newSymbol(FACING_EAST, t), Connective.AND, (Sentence)this.newSymbol(ACTION_TURN_RIGHT, t)), new ComplexSentence(this.newSymbol(FACING_SOUTH, t), Connective.AND, (Sentence)new ComplexSentence(new ComplexSentence(Connective.NOT, this.newSymbol(ACTION_TURN_LEFT, t)), Connective.AND, (Sentence)new ComplexSentence(Connective.NOT, this.newSymbol(ACTION_TURN_RIGHT, t)))))));
        this.tell(new ComplexSentence(this.newSymbol(FACING_EAST, t + 1), Connective.BICONDITIONAL, Sentence.newDisjunction(new ComplexSentence(this.newSymbol(FACING_NORTH, t), Connective.AND, (Sentence)this.newSymbol(ACTION_TURN_RIGHT, t)), new ComplexSentence(this.newSymbol(FACING_SOUTH, t), Connective.AND, (Sentence)this.newSymbol(ACTION_TURN_LEFT, t)), new ComplexSentence(this.newSymbol(FACING_EAST, t), Connective.AND, (Sentence)new ComplexSentence(new ComplexSentence(Connective.NOT, this.newSymbol(ACTION_TURN_LEFT, t)), Connective.AND, (Sentence)new ComplexSentence(Connective.NOT, this.newSymbol(ACTION_TURN_RIGHT, t)))))));
        this.tell(new ComplexSentence(this.newSymbol(FACING_WEST, t + 1), Connective.BICONDITIONAL, Sentence.newDisjunction(new ComplexSentence(this.newSymbol(FACING_NORTH, t), Connective.AND, (Sentence)this.newSymbol(ACTION_TURN_LEFT, t)), new ComplexSentence(this.newSymbol(FACING_SOUTH, t), Connective.AND, (Sentence)this.newSymbol(ACTION_TURN_RIGHT, t)), new ComplexSentence(this.newSymbol(FACING_WEST, t), Connective.AND, (Sentence)new ComplexSentence(new ComplexSentence(Connective.NOT, this.newSymbol(ACTION_TURN_LEFT, t)), Connective.AND, (Sentence)new ComplexSentence(Connective.NOT, this.newSymbol(ACTION_TURN_RIGHT, t)))))));
        this.tell(new ComplexSentence(this.newSymbol(HAVE_ARROW, t + 1), Connective.BICONDITIONAL, (Sentence)new ComplexSentence(this.newSymbol(HAVE_ARROW, t), Connective.AND, (Sentence)new ComplexSentence(Connective.NOT, this.newSymbol(ACTION_SHOOT, t)))));
        this.tell(new ComplexSentence(this.newSymbol(WUMPUS_ALIVE, t + 1), Connective.BICONDITIONAL, (Sentence)new ComplexSentence(this.newSymbol(WUMPUS_ALIVE, t), Connective.AND, (Sentence)new ComplexSentence(Connective.NOT, this.newSymbol(PERCEPT_SCREAM, t + 1)))));
    }

    @Override
    public String toString() {
        List<Sentence> sentences = this.getSentences();
        if (sentences.size() == 0) {
            return "";
        }
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (Sentence s : sentences) {
            if (!first) {
                sb.append("\n");
            }
            sb.append(s.toString());
            first = false;
        }
        return sb.toString();
    }

    public PropositionSymbol newSymbol(String prefix, int timeStep) {
        return new PropositionSymbol(prefix + "_" + timeStep);
    }

    public PropositionSymbol newSymbol(String prefix, int x, int y) {
        return new PropositionSymbol(prefix + "_" + x + "_" + y);
    }

    public PropositionSymbol newSymbol(String prefix, int timeStep, int x, int y) {
        return this.newSymbol(this.newSymbol(prefix, timeStep).toString(), x, y);
    }
}

