/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.wumpusworld;

import aima.core.agent.Action;
import aima.core.environment.wumpusworld.AgentPosition;
import aima.core.environment.wumpusworld.WumpusCave;
import aima.core.environment.wumpusworld.action.Forward;
import aima.core.environment.wumpusworld.action.TurnLeft;
import aima.core.environment.wumpusworld.action.TurnRight;
import aima.core.search.framework.problem.ActionsFunction;
import aima.core.search.framework.problem.ResultFunction;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class WumpusFunctionFactory {
    private static ResultFunction resultFunction = null;

    public static ActionsFunction getActionsFunction(WumpusCave cave) {
        return new WumpusActionsFunction(cave);
    }

    public static ResultFunction getResultFunction() {
        if (null == resultFunction) {
            resultFunction = new WumpusResultFunction();
        }
        return resultFunction;
    }

    private static class WumpusResultFunction
    implements ResultFunction {
        @Override
        public Object result(Object s, Action a) {
            if (a instanceof Forward) {
                Forward fa = (Forward)a;
                return fa.getToPosition();
            }
            if (a instanceof TurnLeft) {
                TurnLeft tLeft = (TurnLeft)a;
                AgentPosition res = (AgentPosition)s;
                return new AgentPosition(res.getX(), res.getY(), tLeft.getToOrientation());
            }
            if (a instanceof TurnRight) {
                TurnRight tRight = (TurnRight)a;
                AgentPosition res = (AgentPosition)s;
                return new AgentPosition(res.getX(), res.getY(), tRight.getToOrientation());
            }
            return s;
        }
    }

    private static class WumpusActionsFunction
    implements ActionsFunction {
        private WumpusCave cave;

        public WumpusActionsFunction(WumpusCave cave) {
            this.cave = cave;
        }

        @Override
        public Set<Action> actions(Object state) {
            LinkedHashSet<Action> actions = new LinkedHashSet<Action>();
            AgentPosition position = null;
            try {
                position = (AgentPosition)state;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            List<AgentPosition> linkedPositions = this.cave.getLocationsLinkedTo(position);
            for (AgentPosition linkPos : linkedPositions) {
                if (linkPos.getX() == position.getX() && linkPos.getY() == position.getY()) continue;
                actions.add(new Forward(position));
            }
            actions.add(new TurnLeft(position.getOrientation()));
            actions.add(new TurnRight(position.getOrientation()));
            return actions;
        }
    }
}

