/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.wumpusworld;

import aima.core.environment.wumpusworld.AgentPosition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WumpusCave {
    private int caveXDimension;
    private int caveYDimension;
    private Set<AgentPosition> allowedPositions = new HashSet<AgentPosition>();

    public WumpusCave() {
        this(4, 4);
    }

    public WumpusCave(int caveXDimension, int caveYDimension) {
        this(caveXDimension, caveYDimension, WumpusCave.defaultAllowedPositions(caveXDimension, caveYDimension));
    }

    public WumpusCave(int caveXDimension, int caveYDimension, Set<AgentPosition> allowedPositions) {
        if (caveXDimension < 1) {
            throw new IllegalArgumentException("Cave must have x dimension >= 1");
        }
        if (caveYDimension < 1) {
            throw new IllegalArgumentException("Case must have y dimension >= 1");
        }
        this.caveXDimension = caveXDimension;
        this.caveYDimension = caveYDimension;
        this.allowedPositions.addAll(allowedPositions);
    }

    public int getCaveXDimension() {
        return this.caveXDimension;
    }

    public int getCaveYDimension() {
        return this.caveYDimension;
    }

    public List<AgentPosition> getLocationsLinkedTo(AgentPosition fromLocation) {
        int x = fromLocation.getX();
        int y = fromLocation.getY();
        AgentPosition.Orientation orientation = fromLocation.getOrientation();
        ArrayList<AgentPosition> result = new ArrayList<AgentPosition>();
        AgentPosition currentForwardNorth = new AgentPosition(x, y + 1, AgentPosition.Orientation.FACING_NORTH);
        AgentPosition currentForwardSouth = new AgentPosition(x, y - 1, AgentPosition.Orientation.FACING_SOUTH);
        AgentPosition currentForwardEast = new AgentPosition(x + 1, y, AgentPosition.Orientation.FACING_EAST);
        AgentPosition currentForwardWest = new AgentPosition(x - 1, y, AgentPosition.Orientation.FACING_WEST);
        AgentPosition currentNorth = new AgentPosition(x, y, AgentPosition.Orientation.FACING_NORTH);
        AgentPosition currentSouth = new AgentPosition(x, y, AgentPosition.Orientation.FACING_SOUTH);
        AgentPosition currentEast = new AgentPosition(x, y, AgentPosition.Orientation.FACING_EAST);
        AgentPosition currentWest = new AgentPosition(x, y, AgentPosition.Orientation.FACING_WEST);
        switch (orientation) {
            case FACING_NORTH: {
                this.addIfAllowed(currentForwardNorth, result);
                this.addIfAllowed(currentEast, result);
                this.addIfAllowed(currentWest, result);
                break;
            }
            case FACING_SOUTH: {
                this.addIfAllowed(currentForwardSouth, result);
                this.addIfAllowed(currentEast, result);
                this.addIfAllowed(currentWest, result);
                break;
            }
            case FACING_EAST: {
                this.addIfAllowed(currentNorth, result);
                this.addIfAllowed(currentSouth, result);
                this.addIfAllowed(currentForwardEast, result);
                break;
            }
            case FACING_WEST: {
                this.addIfAllowed(currentNorth, result);
                this.addIfAllowed(currentSouth, result);
                this.addIfAllowed(currentForwardWest, result);
            }
        }
        return result;
    }

    private static Set<AgentPosition> defaultAllowedPositions(int caveXDimension, int caveYDimension) {
        HashSet<AgentPosition> allowedPositions = new HashSet<AgentPosition>();
        for (int x = 1; x <= caveXDimension; ++x) {
            for (int y = 1; y <= caveYDimension; ++y) {
                for (AgentPosition.Orientation orientation : AgentPosition.Orientation.values()) {
                    allowedPositions.add(new AgentPosition(x, y, orientation));
                }
            }
        }
        return allowedPositions;
    }

    private void addIfAllowed(AgentPosition position, List<AgentPosition> positions) {
        if (this.allowedPositions.contains(position)) {
            positions.add(position);
        }
    }
}

