/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.wumpusworld;

import aima.core.environment.wumpusworld.AgentPosition;
import aima.core.environment.wumpusworld.Room;
import aima.core.search.framework.evalfunc.HeuristicFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ManhattanHeuristicFunction
implements HeuristicFunction {
    List<Room> goals = new ArrayList<Room>();

    public ManhattanHeuristicFunction(Set<Room> goals) {
        this.goals.addAll(goals);
    }

    @Override
    public double h(Object state) {
        AgentPosition pos = (AgentPosition)state;
        int nearestGoalDist = Integer.MAX_VALUE;
        for (Room g : this.goals) {
            int tmp = this.evaluateManhattanDistanceOf(pos.getX(), pos.getY(), g.getX(), g.getY());
            if (tmp >= nearestGoalDist) continue;
            nearestGoalDist = tmp;
        }
        return nearestGoalDist;
    }

    private int evaluateManhattanDistanceOf(int x1, int y1, int x2, int y2) {
        return Math.abs(x1 - x2) + Math.abs(y1 - y2);
    }
}

