/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.wumpusworld;

import aima.core.agent.Action;
import aima.core.agent.Percept;
import aima.core.agent.impl.AbstractAgent;
import aima.core.environment.wumpusworld.AgentPercept;
import aima.core.environment.wumpusworld.AgentPosition;
import aima.core.environment.wumpusworld.ManhattanHeuristicFunction;
import aima.core.environment.wumpusworld.Room;
import aima.core.environment.wumpusworld.WumpusCave;
import aima.core.environment.wumpusworld.WumpusFunctionFactory;
import aima.core.environment.wumpusworld.WumpusKnowledgeBase;
import aima.core.environment.wumpusworld.action.Climb;
import aima.core.environment.wumpusworld.action.Forward;
import aima.core.environment.wumpusworld.action.Grab;
import aima.core.environment.wumpusworld.action.Shoot;
import aima.core.environment.wumpusworld.action.TurnLeft;
import aima.core.search.framework.SearchAgent;
import aima.core.search.framework.problem.GoalTest;
import aima.core.search.framework.problem.Problem;
import aima.core.search.framework.qsearch.GraphSearch;
import aima.core.search.framework.qsearch.QueueSearch;
import aima.core.search.informed.AStarSearch;
import aima.core.util.SetOps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public class HybridWumpusAgent
extends AbstractAgent {
    private WumpusKnowledgeBase kb = null;
    private int t = 0;
    private Queue<Action> plan = new LinkedList<Action>();

    @Override
    public Action execute(Percept percept) {
        this.kb.makePerceptSentence((AgentPercept)percept, this.t);
        this.kb.tellTemporalPhysicsSentences(this.t);
        AgentPosition current = this.kb.askCurrentPosition(this.t);
        Set<Room> safe = this.kb.askSafeRooms(this.t);
        if (this.kb.askGlitter(this.t)) {
            LinkedHashSet<Room> goals = new LinkedHashSet<Room>();
            goals.add(new Room(1, 1));
            this.plan.add(new Grab());
            this.plan.addAll(this.planRoute(current, goals, safe));
            this.plan.add(new Climb());
        }
        Set<Room> unvisited = this.kb.askUnvisitedRooms(this.t);
        if (this.plan.isEmpty()) {
            this.plan.addAll(this.planRoute(current, SetOps.intersection(unvisited, safe), safe));
        }
        if (this.plan.isEmpty() && this.kb.askHaveArrow(this.t)) {
            Set<Room> possibleWumpus = this.kb.askPossibleWumpusRooms(this.t);
            this.plan.addAll(this.planShot(current, possibleWumpus, safe));
        }
        if (this.plan.isEmpty()) {
            Set<Room> notUnsafe = this.kb.askNotUnsafeRooms(this.t);
            this.plan.addAll(this.planRoute(current, SetOps.intersection(unvisited, notUnsafe), safe));
        }
        if (this.plan.isEmpty()) {
            LinkedHashSet<Room> start = new LinkedHashSet<Room>();
            start.add(new Room(1, 1));
            this.plan.addAll(this.planRoute(current, start, safe));
            this.plan.add(new Climb());
        }
        Action action = this.plan.remove();
        this.kb.makeActionSentence(action, this.t);
        ++this.t;
        return action;
    }

    public List<Action> planRoute(AgentPosition current, Set<Room> goals, Set<Room> allowed) {
        LinkedHashSet<AgentPosition> allowedPositions = new LinkedHashSet<AgentPosition>();
        for (Room room : allowed) {
            int x = room.getX();
            int y = room.getY();
            allowedPositions.add(new AgentPosition(x, y, AgentPosition.Orientation.FACING_WEST));
            allowedPositions.add(new AgentPosition(x, y, AgentPosition.Orientation.FACING_EAST));
            allowedPositions.add(new AgentPosition(x, y, AgentPosition.Orientation.FACING_NORTH));
            allowedPositions.add(new AgentPosition(x, y, AgentPosition.Orientation.FACING_SOUTH));
        }
        final LinkedHashSet<AgentPosition> goalPositions = new LinkedHashSet<AgentPosition>();
        for (Room goalRoom : goals) {
            int x = goalRoom.getX();
            int y = goalRoom.getY();
            goalPositions.add(new AgentPosition(x, y, AgentPosition.Orientation.FACING_WEST));
            goalPositions.add(new AgentPosition(x, y, AgentPosition.Orientation.FACING_EAST));
            goalPositions.add(new AgentPosition(x, y, AgentPosition.Orientation.FACING_NORTH));
            goalPositions.add(new AgentPosition(x, y, AgentPosition.Orientation.FACING_SOUTH));
        }
        WumpusCave wumpusCave = new WumpusCave(this.kb.getCaveXDimension(), this.kb.getCaveYDimension(), allowedPositions);
        GoalTest goalTest = new GoalTest(){

            @Override
            public boolean isGoalState(Object state) {
                return goalPositions.contains(state);
            }
        };
        Problem problem = new Problem(current, WumpusFunctionFactory.getActionsFunction(wumpusCave), WumpusFunctionFactory.getResultFunction(), goalTest);
        ManhattanHeuristicFunction hf = new ManhattanHeuristicFunction(goals);
        AStarSearch search = new AStarSearch((QueueSearch)new GraphSearch(), hf);
        SearchAgent agent = null;
        List<Action> actions = null;
        try {
            agent = new SearchAgent(problem, search);
            actions = agent.getActions();
            if (actions.size() == 1 && actions.get(0).isNoOp()) {
                actions = new ArrayList<Action>();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return actions;
    }

    public List<Action> planShot(AgentPosition current, Set<Room> possibleWumpus, Set<Room> allowed) {
        LinkedHashSet<AgentPosition> shootingPositions = new LinkedHashSet<AgentPosition>();
        for (Room p : possibleWumpus) {
            int x = p.getX();
            int y = p.getY();
            for (int i = 1; i <= this.kb.getCaveXDimension(); ++i) {
                if (i < x) {
                    shootingPositions.add(new AgentPosition(i, y, AgentPosition.Orientation.FACING_EAST));
                }
                if (i > x) {
                    shootingPositions.add(new AgentPosition(i, y, AgentPosition.Orientation.FACING_WEST));
                }
                if (i < y) {
                    shootingPositions.add(new AgentPosition(x, i, AgentPosition.Orientation.FACING_NORTH));
                }
                if (i <= y) continue;
                shootingPositions.add(new AgentPosition(x, i, AgentPosition.Orientation.FACING_SOUTH));
            }
        }
        for (Room p : possibleWumpus) {
            for (AgentPosition.Orientation orientation : AgentPosition.Orientation.values()) {
                shootingPositions.remove(new AgentPosition(p.getX(), p.getY(), orientation));
            }
        }
        Iterator it = shootingPositions.iterator();
        LinkedHashSet<Room> shootingPositionsArray = new LinkedHashSet<Room>();
        while (it.hasNext()) {
            AgentPosition tmp = (AgentPosition)it.next();
            shootingPositionsArray.add(new Room(tmp.getX(), tmp.getY()));
        }
        List<Action> actions = this.planRoute(current, shootingPositionsArray, allowed);
        AgentPosition newPos = current;
        if (actions.size() > 0) {
            newPos = ((Forward)actions.get(actions.size() - 1)).getToPosition();
        }
        while (!shootingPositions.contains(newPos)) {
            TurnLeft tLeft = new TurnLeft(newPos.getOrientation());
            newPos = new AgentPosition(newPos.getX(), newPos.getY(), tLeft.getToOrientation());
            actions.add(tLeft);
        }
        actions.add(new Shoot());
        return actions;
    }

    public HybridWumpusAgent() {
        this(4);
    }

    public HybridWumpusAgent(int caveXandYDimensions) {
        this.kb = new WumpusKnowledgeBase(caveXandYDimensions);
    }
}

