/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.wumpusworld;

import aima.core.environment.wumpusworld.Room;

public class AgentPosition {
    private Room room;
    private Orientation orientation;

    public AgentPosition(int x, int y, Orientation orientation) {
        this(new Room(x, y), orientation);
    }

    public AgentPosition(Room room, Orientation orientation) {
        this.room = room;
        this.orientation = orientation;
    }

    public Room getRoom() {
        return this.room;
    }

    public int getX() {
        return this.room.getX();
    }

    public int getY() {
        return this.room.getY();
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public String toString() {
        return this.room.toString() + "->" + (Object)((Object)this.orientation);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof AgentPosition) {
            AgentPosition othAgent = (AgentPosition)obj;
            return this.getX() == othAgent.getX() && this.getY() == othAgent.getY() && this.orientation == othAgent.getOrientation();
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.room.hashCode();
        result = 43 * result + this.orientation.hashCode();
        return result;
    }

    public static enum Orientation {
        FACING_NORTH("FacingNorth"),
        FACING_SOUTH("FacingSouth"),
        FACING_EAST("FacingEast"),
        FACING_WEST("FacingWest");

        private final String name;

        public String toString() {
            return this.name;
        }

        private Orientation(String name) {
            this.name = name;
        }
    }
}

