/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.vacuum;

import aima.core.agent.Agent;
import aima.core.agent.EnvironmentState;
import aima.core.environment.vacuum.FullyObservableVacuumEnvironmentPercept;
import aima.core.environment.vacuum.VacuumEnvironment;
import java.util.LinkedHashMap;
import java.util.Map;

public class VacuumEnvironmentState
implements EnvironmentState,
FullyObservableVacuumEnvironmentPercept,
Cloneable {
    private Map<String, VacuumEnvironment.LocationState> state = new LinkedHashMap<String, VacuumEnvironment.LocationState>();
    private Map<Agent, String> agentLocations = new LinkedHashMap<Agent, String>();

    public VacuumEnvironmentState() {
    }

    public VacuumEnvironmentState(VacuumEnvironment.LocationState locAState, VacuumEnvironment.LocationState locBState) {
        this();
        this.state.put("A", locAState);
        this.state.put("B", locBState);
    }

    @Override
    public String getAgentLocation(Agent a) {
        return this.agentLocations.get(a);
    }

    public void setAgentLocation(Agent a, String location) {
        this.agentLocations.put(a, location);
    }

    @Override
    public VacuumEnvironment.LocationState getLocationState(String location) {
        return this.state.get(location);
    }

    public void setLocationState(String location, VacuumEnvironment.LocationState s) {
        this.state.put(location, s);
    }

    public boolean equals(Object obj) {
        if (this.getClass() == obj.getClass()) {
            VacuumEnvironmentState s = (VacuumEnvironmentState)obj;
            return this.state.equals(s.state) && this.agentLocations.equals(s.agentLocations);
        }
        return false;
    }

    public int hashCode() {
        return 3 * this.state.hashCode() + 13 * this.agentLocations.hashCode();
    }

    public VacuumEnvironmentState clone() {
        VacuumEnvironmentState result = null;
        try {
            result = (VacuumEnvironmentState)super.clone();
            result.state = new LinkedHashMap<String, VacuumEnvironment.LocationState>(this.state);
            this.agentLocations = new LinkedHashMap<Agent, String>(this.agentLocations);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public String toString() {
        return this.state.toString();
    }
}

