/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.vacuum;

import aima.core.agent.Action;
import aima.core.agent.Agent;
import aima.core.agent.EnvironmentState;
import aima.core.agent.Percept;
import aima.core.agent.impl.AbstractEnvironment;
import aima.core.agent.impl.DynamicAction;
import aima.core.environment.vacuum.LocalVacuumEnvironmentPercept;
import aima.core.environment.vacuum.NondeterministicVacuumAgent;
import aima.core.environment.vacuum.VacuumEnvironmentState;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class VacuumEnvironment
extends AbstractEnvironment {
    public static final Action ACTION_MOVE_LEFT = new DynamicAction("Left");
    public static final Action ACTION_MOVE_RIGHT = new DynamicAction("Right");
    public static final Action ACTION_SUCK = new DynamicAction("Suck");
    public static final String LOCATION_A = "A";
    public static final String LOCATION_B = "B";
    protected VacuumEnvironmentState envState = null;
    protected boolean isDone = false;

    public VacuumEnvironment() {
        Random r = new Random();
        this.envState = new VacuumEnvironmentState(0 == r.nextInt(2) ? LocationState.Clean : LocationState.Dirty, 0 == r.nextInt(2) ? LocationState.Clean : LocationState.Dirty);
    }

    public VacuumEnvironment(LocationState locAState, LocationState locBState) {
        this.envState = new VacuumEnvironmentState(locAState, locBState);
    }

    public EnvironmentState getCurrentState() {
        return this.envState;
    }

    public List<String> getLocations() {
        return Arrays.asList(LOCATION_A, LOCATION_B);
    }

    @Override
    public void executeAction(Agent a, Action agentAction) {
        if (ACTION_MOVE_RIGHT == agentAction) {
            this.envState.setAgentLocation(a, LOCATION_B);
            this.updatePerformanceMeasure(a, -1.0);
        } else if (ACTION_MOVE_LEFT == agentAction) {
            this.envState.setAgentLocation(a, LOCATION_A);
            this.updatePerformanceMeasure(a, -1.0);
        } else if (ACTION_SUCK == agentAction) {
            if (LocationState.Dirty == this.envState.getLocationState(this.envState.getAgentLocation(a))) {
                this.envState.setLocationState(this.envState.getAgentLocation(a), LocationState.Clean);
                this.updatePerformanceMeasure(a, 10.0);
            }
        } else if (agentAction.isNoOp()) {
            this.isDone = true;
        }
    }

    @Override
    public Percept getPerceptSeenBy(Agent anAgent) {
        if (anAgent instanceof NondeterministicVacuumAgent) {
            return this.envState.clone();
        }
        String agentLocation = this.envState.getAgentLocation(anAgent);
        return new LocalVacuumEnvironmentPercept(agentLocation, this.envState.getLocationState(agentLocation));
    }

    @Override
    public boolean isDone() {
        return super.isDone() || this.isDone;
    }

    @Override
    public void addAgent(Agent a) {
        int idx = new Random().nextInt(2);
        this.envState.setAgentLocation(a, idx == 0 ? LOCATION_A : LOCATION_B);
        super.addAgent(a);
    }

    public void addAgent(Agent a, String location) {
        this.envState.setAgentLocation(a, location);
        super.addAgent(a);
    }

    public LocationState getLocationState(String location) {
        return this.envState.getLocationState(location);
    }

    public String getAgentLocation(Agent a) {
        return this.envState.getAgentLocation(a);
    }

    public static enum LocationState {
        Clean,
        Dirty;

    }
}

