/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.vacuum;

import aima.core.agent.Action;
import aima.core.agent.Percept;
import aima.core.agent.impl.AbstractAgent;
import aima.core.agent.impl.NoOpAction;
import aima.core.environment.vacuum.VacuumEnvironment;
import aima.core.environment.vacuum.VacuumEnvironmentState;
import aima.core.search.framework.PerceptToStateFunction;
import aima.core.search.nondeterministic.AndOrSearch;
import aima.core.search.nondeterministic.IfStateThenPlan;
import aima.core.search.nondeterministic.NondeterministicProblem;
import aima.core.search.nondeterministic.Plan;
import java.util.LinkedList;

public class NondeterministicVacuumAgent
extends AbstractAgent {
    private NondeterministicProblem problem;
    private PerceptToStateFunction ptsFunction;
    private Plan contingencyPlan;
    private LinkedList<Object> stack = new LinkedList();

    public NondeterministicVacuumAgent(PerceptToStateFunction ptsFunction) {
        this.setPerceptToStateFunction(ptsFunction);
    }

    public NondeterministicProblem getProblem() {
        return this.problem;
    }

    public void setProblem(NondeterministicProblem problem) {
        this.problem = problem;
        this.init();
    }

    public PerceptToStateFunction getPerceptToStateFunction() {
        return this.ptsFunction;
    }

    public void setPerceptToStateFunction(PerceptToStateFunction ptsFunction) {
        this.ptsFunction = ptsFunction;
    }

    public Plan getContingencyPlan() {
        if (this.contingencyPlan == null) {
            throw new RuntimeException("Contingency plan not set.");
        }
        return this.contingencyPlan;
    }

    @Override
    public Action execute(Percept percept) {
        Object currentStep;
        VacuumEnvironmentState state = (VacuumEnvironmentState)this.getPerceptToStateFunction().getState(percept);
        if (state.getLocationState("A") == VacuumEnvironment.LocationState.Clean && state.getLocationState("B") == VacuumEnvironment.LocationState.Clean) {
            return NoOpAction.NO_OP;
        }
        if (this.stack.size() < 1) {
            if (this.contingencyPlan.size() < 1) {
                return NoOpAction.NO_OP;
            }
            this.stack.push(this.getContingencyPlan().removeFirst());
        }
        if ((currentStep = this.stack.peek()) instanceof Action) {
            return (Action)this.stack.remove();
        }
        if (currentStep instanceof Plan) {
            Plan newPlan = (Plan)currentStep;
            if (newPlan.size() > 0) {
                this.stack.push(newPlan.removeFirst());
            } else {
                this.stack.remove();
            }
            return this.execute(percept);
        }
        if (currentStep instanceof IfStateThenPlan) {
            IfStateThenPlan conditional = (IfStateThenPlan)this.stack.remove();
            this.stack.push(conditional.ifStateMatches(percept));
            return this.execute(percept);
        }
        if (currentStep == null) {
            this.stack.remove();
            return this.execute(percept);
        }
        throw new RuntimeException("Unrecognized contingency plan step.");
    }

    private void init() {
        this.setAlive(true);
        this.stack.clear();
        AndOrSearch andOrSearch = new AndOrSearch();
        this.contingencyPlan = andOrSearch.search(this.problem);
    }
}

