/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.vacuum;

import aima.core.agent.Action;
import aima.core.agent.Model;
import aima.core.agent.Percept;
import aima.core.agent.impl.AbstractAgent;
import aima.core.agent.impl.DynamicState;
import aima.core.agent.impl.NoOpAction;
import aima.core.agent.impl.aprog.ModelBasedReflexAgentProgram;
import aima.core.agent.impl.aprog.simplerule.ANDCondition;
import aima.core.agent.impl.aprog.simplerule.EQUALCondition;
import aima.core.agent.impl.aprog.simplerule.Rule;
import aima.core.environment.vacuum.LocalVacuumEnvironmentPercept;
import aima.core.environment.vacuum.VacuumEnvironment;
import java.util.LinkedHashSet;
import java.util.Set;

public class ModelBasedReflexVacuumAgent
extends AbstractAgent {
    private static final String ATTRIBUTE_CURRENT_LOCATION = "currentLocation";
    private static final String ATTRIBUTE_CURRENT_STATE = "currentState";
    private static final String ATTRIBUTE_STATE_LOCATION_A = "stateLocationA";
    private static final String ATTRIBUTE_STATE_LOCATION_B = "stateLocationB";

    public ModelBasedReflexVacuumAgent() {
        super(new ModelBasedReflexAgentProgram(){

            @Override
            protected void init() {
                this.setState(new DynamicState());
                this.setRules(ModelBasedReflexVacuumAgent.getRuleSet());
            }

            @Override
            protected DynamicState updateState(DynamicState state, Action anAction, Percept percept, Model model) {
                LocalVacuumEnvironmentPercept vep = (LocalVacuumEnvironmentPercept)percept;
                state.setAttribute(ModelBasedReflexVacuumAgent.ATTRIBUTE_CURRENT_LOCATION, vep.getAgentLocation());
                state.setAttribute(ModelBasedReflexVacuumAgent.ATTRIBUTE_CURRENT_STATE, (Object)vep.getLocationState());
                if ("A" == vep.getAgentLocation()) {
                    state.setAttribute(ModelBasedReflexVacuumAgent.ATTRIBUTE_STATE_LOCATION_A, (Object)vep.getLocationState());
                } else {
                    state.setAttribute(ModelBasedReflexVacuumAgent.ATTRIBUTE_STATE_LOCATION_B, (Object)vep.getLocationState());
                }
                return state;
            }
        });
    }

    private static Set<Rule> getRuleSet() {
        LinkedHashSet<Rule> rules = new LinkedHashSet<Rule>();
        rules.add(new Rule(new ANDCondition(new EQUALCondition(ATTRIBUTE_STATE_LOCATION_A, (Object)VacuumEnvironment.LocationState.Clean), new EQUALCondition(ATTRIBUTE_STATE_LOCATION_B, (Object)VacuumEnvironment.LocationState.Clean)), NoOpAction.NO_OP));
        rules.add(new Rule(new EQUALCondition(ATTRIBUTE_CURRENT_STATE, (Object)VacuumEnvironment.LocationState.Dirty), VacuumEnvironment.ACTION_SUCK));
        rules.add(new Rule(new EQUALCondition(ATTRIBUTE_CURRENT_LOCATION, "A"), VacuumEnvironment.ACTION_MOVE_RIGHT));
        rules.add(new Rule(new EQUALCondition(ATTRIBUTE_CURRENT_LOCATION, "B"), VacuumEnvironment.ACTION_MOVE_LEFT));
        return rules;
    }
}

