/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.tictactoe;

import aima.core.util.datastructure.XYLocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TicTacToeState
implements Cloneable {
    public static final String O = "O";
    public static final String X = "X";
    public static final String EMPTY = "-";
    private String[] board = new String[]{"-", "-", "-", "-", "-", "-", "-", "-", "-"};
    private String playerToMove = "X";
    private double utility = -1.0;

    public String getPlayerToMove() {
        return this.playerToMove;
    }

    public boolean isEmpty(int col, int row) {
        return this.board[this.getAbsPosition(col, row)] == EMPTY;
    }

    public String getValue(int col, int row) {
        return this.board[this.getAbsPosition(col, row)];
    }

    public double getUtility() {
        return this.utility;
    }

    public void mark(XYLocation action) {
        this.mark(action.getXCoOrdinate(), action.getYCoOrdinate());
    }

    public void mark(int col, int row) {
        if (this.utility == -1.0 && this.getValue(col, row) == EMPTY) {
            this.board[this.getAbsPosition((int)col, (int)row)] = this.playerToMove;
            this.analyzeUtility();
            this.playerToMove = this.playerToMove == X ? O : X;
        }
    }

    private void analyzeUtility() {
        if (this.lineThroughBoard()) {
            this.utility = this.playerToMove == X ? 1 : 0;
        } else if (this.getNumberOfMarkedPositions() == 9) {
            this.utility = 0.5;
        }
    }

    public boolean lineThroughBoard() {
        return this.isAnyRowComplete() || this.isAnyColumnComplete() || this.isAnyDiagonalComplete();
    }

    private boolean isAnyRowComplete() {
        for (int row = 0; row < 3; ++row) {
            String val = this.getValue(0, row);
            if (val == EMPTY || val != this.getValue(1, row) || val != this.getValue(2, row)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnyColumnComplete() {
        for (int col = 0; col < 3; ++col) {
            String val = this.getValue(col, 0);
            if (val == EMPTY || val != this.getValue(col, 1) || val != this.getValue(col, 2)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnyDiagonalComplete() {
        boolean retVal = false;
        String val = this.getValue(0, 0);
        if (val != EMPTY && val == this.getValue(1, 1) && val == this.getValue(2, 2)) {
            return true;
        }
        val = this.getValue(0, 2);
        if (val != EMPTY && val == this.getValue(1, 1) && val == this.getValue(2, 0)) {
            return true;
        }
        return retVal;
    }

    public int getNumberOfMarkedPositions() {
        int retVal = 0;
        for (int col = 0; col < 3; ++col) {
            for (int row = 0; row < 3; ++row) {
                if (this.isEmpty(col, row)) continue;
                ++retVal;
            }
        }
        return retVal;
    }

    public List<XYLocation> getUnMarkedPositions() {
        ArrayList<XYLocation> result = new ArrayList<XYLocation>();
        for (int col = 0; col < 3; ++col) {
            for (int row = 0; row < 3; ++row) {
                if (!this.isEmpty(col, row)) continue;
                result.add(new XYLocation(col, row));
            }
        }
        return result;
    }

    public TicTacToeState clone() {
        TicTacToeState copy = null;
        try {
            copy = (TicTacToeState)super.clone();
            copy.board = Arrays.copyOf(this.board, this.board.length);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return copy;
    }

    public boolean equals(Object anObj) {
        if (anObj != null && anObj.getClass() == this.getClass()) {
            TicTacToeState anotherState = (TicTacToeState)anObj;
            for (int i = 0; i < 9; ++i) {
                if (this.board[i] == anotherState.board[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                strBuilder.append(this.getValue(col, row) + " ");
            }
            strBuilder.append("\n");
        }
        return strBuilder.toString();
    }

    private int getAbsPosition(int col, int row) {
        return row * 3 + col;
    }
}

