/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.nqueens;

import aima.core.environment.nqueens.NQueensBoard;
import aima.core.environment.nqueens.NQueensGoalTest;
import aima.core.search.framework.problem.GoalTest;
import aima.core.search.local.FitnessFunction;
import aima.core.search.local.Individual;
import aima.core.util.datastructure.XYLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class NQueensGenAlgoUtil {
    public static FitnessFunction<Integer> getFitnessFunction() {
        return new NQueensFitnessFunction();
    }

    public static GoalTest getGoalTest() {
        return new NQueensGenAlgoGoalTest();
    }

    public static Individual<Integer> generateRandomIndividual(int boardSize) {
        ArrayList<Integer> individualRepresentation = new ArrayList<Integer>();
        for (int i = 0; i < boardSize; ++i) {
            individualRepresentation.add(new Random().nextInt(boardSize));
        }
        Individual<Integer> individual = new Individual<Integer>(individualRepresentation);
        return individual;
    }

    public static Collection<Integer> getFiniteAlphabetForBoardOfSize(int size) {
        ArrayList<Integer> fab = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            fab.add(i);
        }
        return fab;
    }

    public static NQueensBoard getBoardForIndividual(Individual<Integer> individual) {
        int boardSize = individual.length();
        NQueensBoard board = new NQueensBoard(boardSize);
        for (int i = 0; i < boardSize; ++i) {
            int pos = individual.getRepresentation().get(i);
            board.addQueenAt(new XYLocation(i, pos));
        }
        return board;
    }

    public static class NQueensGenAlgoGoalTest
    implements GoalTest {
        private final NQueensGoalTest goalTest = new NQueensGoalTest();

        @Override
        public boolean isGoalState(Object state) {
            return this.goalTest.isGoalState(NQueensGenAlgoUtil.getBoardForIndividual((Individual)state));
        }
    }

    public static class NQueensFitnessFunction
    implements FitnessFunction<Integer> {
        @Override
        public double apply(Individual<Integer> individual) {
            double fitness = 0.0;
            NQueensBoard board = NQueensGenAlgoUtil.getBoardForIndividual(individual);
            int boardSize = board.getSize();
            List<XYLocation> qPositions = board.getQueenPositions();
            for (int fromX = 0; fromX < boardSize - 1; ++fromX) {
                for (int toX = fromX + 1; toX < boardSize; ++toX) {
                    int fromY = qPositions.get(fromX).getYCoOrdinate();
                    boolean nonAttackingPair = true;
                    int toY = fromY;
                    if (board.queenExistsAt(new XYLocation(toX, toY))) {
                        nonAttackingPair = false;
                    }
                    if ((toY = fromY - (toX - fromX)) >= 0 && board.queenExistsAt(new XYLocation(toX, toY))) {
                        nonAttackingPair = false;
                    }
                    if ((toY = fromY + (toX - fromX)) < boardSize && board.queenExistsAt(new XYLocation(toX, toY))) {
                        nonAttackingPair = false;
                    }
                    if (!nonAttackingPair) continue;
                    fitness += 1.0;
                }
            }
            return fitness;
        }
    }
}

