/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.nqueens;

import aima.core.agent.Action;
import aima.core.environment.nqueens.NQueensBoard;
import aima.core.environment.nqueens.QueenAction;
import aima.core.search.framework.problem.ActionsFunction;
import aima.core.search.framework.problem.ResultFunction;
import aima.core.util.datastructure.XYLocation;
import java.util.LinkedHashSet;
import java.util.Set;

public class NQueensFunctionFactory {
    private static ActionsFunction _iActionsFunction = null;
    private static ActionsFunction _cActionsFunction = null;
    private static ResultFunction _resultFunction = null;

    public static ActionsFunction getIActionsFunction() {
        if (null == _iActionsFunction) {
            _iActionsFunction = new NQIActionsFunction();
        }
        return _iActionsFunction;
    }

    public static ActionsFunction getCActionsFunction() {
        if (null == _cActionsFunction) {
            _cActionsFunction = new NQCActionsFunction();
        }
        return _cActionsFunction;
    }

    public static ResultFunction getResultFunction() {
        if (null == _resultFunction) {
            _resultFunction = new NQResultFunction();
        }
        return _resultFunction;
    }

    private static class NQResultFunction
    implements ResultFunction {
        private NQResultFunction() {
        }

        @Override
        public Object result(Object s, Action a) {
            if (a instanceof QueenAction) {
                QueenAction qa = (QueenAction)a;
                NQueensBoard board = (NQueensBoard)s;
                NQueensBoard newBoard = new NQueensBoard(board.getSize());
                newBoard.setBoard(board.getQueenPositions());
                if (qa.getName() == "placeQueenAt") {
                    newBoard.addQueenAt(qa.getLocation());
                } else if (qa.getName() == "removeQueenAt") {
                    newBoard.removeQueenFrom(qa.getLocation());
                } else if (qa.getName() == "moveQueenTo") {
                    newBoard.moveQueenTo(qa.getLocation());
                }
                s = newBoard;
            }
            return s;
        }
    }

    private static class NQCActionsFunction
    implements ActionsFunction {
        private NQCActionsFunction() {
        }

        @Override
        public Set<Action> actions(Object state) {
            LinkedHashSet<Action> actions = new LinkedHashSet<Action>();
            NQueensBoard board = (NQueensBoard)state;
            for (int i = 0; i < board.getSize(); ++i) {
                for (int j = 0; j < board.getSize(); ++j) {
                    XYLocation loc = new XYLocation(i, j);
                    if (board.queenExistsAt(loc)) continue;
                    actions.add(new QueenAction("moveQueenTo", loc));
                }
            }
            return actions;
        }
    }

    private static class NQIActionsFunction
    implements ActionsFunction {
        private NQIActionsFunction() {
        }

        @Override
        public Set<Action> actions(Object state) {
            NQueensBoard board = (NQueensBoard)state;
            LinkedHashSet<Action> actions = new LinkedHashSet<Action>();
            int numQueens = board.getNumberOfQueensOnBoard();
            int boardSize = board.getSize();
            for (int i = 0; i < boardSize; ++i) {
                XYLocation newLocation = new XYLocation(numQueens, i);
                if (board.isSquareUnderAttack(newLocation)) continue;
                actions.add(new QueenAction("placeQueenAt", newLocation));
            }
            return actions;
        }
    }
}

