/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.nqueens;

import aima.core.util.datastructure.XYLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class NQueensBoard {
    int[][] squares;
    int size;

    public NQueensBoard(int size) {
        this.size = size;
        this.squares = new int[size][size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                this.squares[i][j] = 0;
            }
        }
    }

    public NQueensBoard(int size, Config config) {
        block3: {
            block2: {
                this(size);
                if (config != Config.QUEENS_IN_FIRST_ROW) break block2;
                for (int i = 0; i < size; ++i) {
                    this.addQueenAt(new XYLocation(i, 0));
                }
                break block3;
            }
            if (config != Config.QUEEN_IN_EVERY_COL) break block3;
            Random r = new Random();
            for (int i = 0; i < size; ++i) {
                this.addQueenAt(new XYLocation(i, r.nextInt(size)));
            }
        }
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                this.squares[i][j] = 0;
            }
        }
    }

    public void setBoard(List<XYLocation> al) {
        this.clear();
        for (int i = 0; i < al.size(); ++i) {
            this.addQueenAt(al.get(i));
        }
    }

    public int getSize() {
        return this.size;
    }

    public void addQueenAt(XYLocation l) {
        if (!this.queenExistsAt(l)) {
            this.squares[l.getXCoOrdinate()][l.getYCoOrdinate()] = 1;
        }
    }

    public void removeQueenFrom(XYLocation l) {
        if (this.squares[l.getXCoOrdinate()][l.getYCoOrdinate()] == 1) {
            this.squares[l.getXCoOrdinate()][l.getYCoOrdinate()] = 0;
        }
    }

    public void moveQueenTo(XYLocation l) {
        for (int i = 0; i < this.size; ++i) {
            this.squares[l.getXCoOrdinate()][i] = 0;
        }
        this.squares[l.getXCoOrdinate()][l.getYCoOrdinate()] = 1;
    }

    public void moveQueen(XYLocation from, XYLocation to) {
        if (this.queenExistsAt(from) && !this.queenExistsAt(to)) {
            this.removeQueenFrom(from);
            this.addQueenAt(to);
        }
    }

    public boolean queenExistsAt(XYLocation l) {
        return this.queenExistsAt(l.getXCoOrdinate(), l.getYCoOrdinate());
    }

    private boolean queenExistsAt(int x, int y) {
        return this.squares[x][y] == 1;
    }

    public int getNumberOfQueensOnBoard() {
        int count = 0;
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                if (this.squares[i][j] != 1) continue;
                ++count;
            }
        }
        return count;
    }

    public List<XYLocation> getQueenPositions() {
        ArrayList<XYLocation> result = new ArrayList<XYLocation>();
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                if (!this.queenExistsAt(i, j)) continue;
                result.add(new XYLocation(i, j));
            }
        }
        return result;
    }

    public int getNumberOfAttackingPairs() {
        int result = 0;
        for (XYLocation location : this.getQueenPositions()) {
            result += this.getNumberOfAttacksOn(location);
        }
        return result / 2;
    }

    public int getNumberOfAttacksOn(XYLocation l) {
        int x = l.getXCoOrdinate();
        int y = l.getYCoOrdinate();
        return this.numberOfHorizontalAttacksOn(x, y) + this.numberOfVerticalAttacksOn(x, y) + this.numberOfDiagonalAttacksOn(x, y);
    }

    public boolean isSquareUnderAttack(XYLocation l) {
        int y;
        int x = l.getXCoOrdinate();
        return this.isSquareHorizontallyAttacked(x, y = l.getYCoOrdinate()) || this.isSquareVerticallyAttacked(x, y) || this.isSquareDiagonallyAttacked(x, y);
    }

    private boolean isSquareHorizontallyAttacked(int x, int y) {
        return this.numberOfHorizontalAttacksOn(x, y) > 0;
    }

    private boolean isSquareVerticallyAttacked(int x, int y) {
        return this.numberOfVerticalAttacksOn(x, y) > 0;
    }

    private boolean isSquareDiagonallyAttacked(int x, int y) {
        return this.numberOfDiagonalAttacksOn(x, y) > 0;
    }

    private int numberOfHorizontalAttacksOn(int x, int y) {
        int retVal = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!this.queenExistsAt(i, y) || i == x) continue;
            ++retVal;
        }
        return retVal;
    }

    private int numberOfVerticalAttacksOn(int x, int y) {
        int retVal = 0;
        for (int j = 0; j < this.size; ++j) {
            if (!this.queenExistsAt(x, j) || j == y) continue;
            ++retVal;
        }
        return retVal;
    }

    private int numberOfDiagonalAttacksOn(int x, int y) {
        int j;
        int retVal = 0;
        int i = x + 1;
        for (j = y - 1; i < this.size && j > -1; ++i, --j) {
            if (!this.queenExistsAt(i, j)) continue;
            ++retVal;
        }
        i = x + 1;
        for (j = y + 1; i < this.size && j < this.size; ++i, ++j) {
            if (!this.queenExistsAt(i, j)) continue;
            ++retVal;
        }
        i = x - 1;
        for (j = y - 1; i > -1 && j > -1; --i, --j) {
            if (!this.queenExistsAt(i, j)) continue;
            ++retVal;
        }
        i = x - 1;
        for (j = y + 1; i > -1 && j < this.size; --i, ++j) {
            if (!this.queenExistsAt(i, j)) continue;
            ++retVal;
        }
        return retVal;
    }

    public int hashCode() {
        List<XYLocation> locs = this.getQueenPositions();
        int result = 17;
        for (XYLocation loc : locs) {
            result = 37 * loc.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NQueensBoard aBoard = (NQueensBoard)o;
        boolean retVal = true;
        List<XYLocation> locs = this.getQueenPositions();
        for (XYLocation loc : locs) {
            if (aBoard.queenExistsAt(loc)) continue;
            retVal = false;
        }
        return retVal;
    }

    public void print() {
        System.out.println(this.getBoardPic());
    }

    public String getBoardPic() {
        StringBuffer buffer = new StringBuffer();
        for (int row = 0; row < this.size; ++row) {
            for (int col = 0; col < this.size; ++col) {
                if (this.queenExistsAt(col, row)) {
                    buffer.append(" Q ");
                    continue;
                }
                buffer.append(" - ");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int row = 0; row < this.size; ++row) {
            for (int col = 0; col < this.size; ++col) {
                if (this.queenExistsAt(col, row)) {
                    buf.append('Q');
                    continue;
                }
                buf.append('-');
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public static enum Config {
        EMPTY,
        QUEENS_IN_FIRST_ROW,
        QUEEN_IN_EVERY_COL;

    }
}

