/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.map;

import aima.core.agent.Action;
import aima.core.agent.EnvironmentViewNotifier;
import aima.core.agent.Percept;
import aima.core.agent.State;
import aima.core.agent.impl.DynamicPercept;
import aima.core.agent.impl.DynamicState;
import aima.core.environment.map.BidirectionalMapProblem;
import aima.core.environment.map.Map;
import aima.core.search.framework.SearchForActions;
import aima.core.search.framework.SimpleProblemSolvingAgent;
import aima.core.search.framework.problem.Problem;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SimpleMapAgent
extends SimpleProblemSolvingAgent {
    protected Map map = null;
    protected DynamicState state = new DynamicState();
    private EnvironmentViewNotifier notifier = null;
    private SearchForActions search = null;
    private String[] goals = null;
    private int goalTestPos = 0;

    public SimpleMapAgent(Map map, EnvironmentViewNotifier notifier, SearchForActions search) {
        this.map = map;
        this.notifier = notifier;
        this.search = search;
    }

    public SimpleMapAgent(Map map, EnvironmentViewNotifier notifier, SearchForActions search, int maxGoalsToFormulate) {
        super(maxGoalsToFormulate);
        this.map = map;
        this.notifier = notifier;
        this.search = search;
    }

    public SimpleMapAgent(Map map, EnvironmentViewNotifier notifier, SearchForActions search, String[] goals) {
        this(map, search, goals);
        this.notifier = notifier;
    }

    public SimpleMapAgent(Map map, SearchForActions search, String[] goals) {
        super(goals.length);
        this.map = map;
        this.search = search;
        this.goals = new String[goals.length];
        System.arraycopy(goals, 0, this.goals, 0, goals.length);
    }

    @Override
    protected State updateState(Percept p) {
        DynamicPercept dp = (DynamicPercept)p;
        this.state.setAttribute("location", dp.getAttribute("in"));
        return this.state;
    }

    @Override
    protected Object formulateGoal() {
        String goal = null;
        if (null == this.goals) {
            goal = this.map.randomlyGenerateDestination();
        } else {
            goal = this.goals[this.goalTestPos];
            ++this.goalTestPos;
        }
        if (this.notifier != null) {
            this.notifier.notifyViews("CurrentLocation=In(" + this.state.getAttribute("location") + "), Goal=In(" + goal + ")");
        }
        return goal;
    }

    @Override
    protected Problem formulateProblem(Object goal) {
        return new BidirectionalMapProblem(this.map, (String)this.state.getAttribute("location"), (String)goal);
    }

    @Override
    protected List<Action> search(Problem problem) {
        ArrayList<Action> result = new ArrayList<Action>();
        try {
            result.addAll(this.search.findActions(problem));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Override
    protected void notifyViewOfMetrics() {
        if (this.notifier != null) {
            Set<String> keys = this.search.getMetrics().keySet();
            for (String key : keys) {
                this.notifier.notifyViews("METRIC[" + key + "]=" + this.search.getMetrics().get(key));
            }
        }
    }
}

