/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.map;

import aima.core.agent.Action;
import aima.core.agent.Percept;
import aima.core.agent.impl.DynamicPercept;
import aima.core.environment.map.Map;
import aima.core.environment.map.MoveToAction;
import aima.core.search.framework.PerceptToStateFunction;
import aima.core.search.framework.evalfunc.HeuristicFunction;
import aima.core.search.framework.problem.ActionsFunction;
import aima.core.search.framework.problem.ResultFunction;
import aima.core.util.math.geom.shapes.Point2D;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class MapFunctionFactory {
    private static ResultFunction resultFunction;
    private static PerceptToStateFunction perceptToStateFunction;

    public static ActionsFunction getActionsFunction(Map map) {
        return new MapActionsFunction(map, false);
    }

    public static ActionsFunction getReverseActionsFunction(Map map) {
        return new MapActionsFunction(map, true);
    }

    public static ResultFunction getResultFunction() {
        if (null == resultFunction) {
            resultFunction = new MapResultFunction();
        }
        return resultFunction;
    }

    public static HeuristicFunction getSLDHeuristicFunction(Object goal, Map map) {
        return new StraightLineDistanceHeuristicFunction(goal, map);
    }

    public static HeuristicFunction getZeroHeuristicFunction() {
        return new ZeroHeuristicFunction();
    }

    public static PerceptToStateFunction getPerceptToStateFunction() {
        if (null == perceptToStateFunction) {
            perceptToStateFunction = new MapPerceptToStateFunction();
        }
        return perceptToStateFunction;
    }

    private static class ZeroHeuristicFunction
    implements HeuristicFunction {
        private ZeroHeuristicFunction() {
        }

        @Override
        public double h(Object state) {
            return 0.0;
        }
    }

    private static class StraightLineDistanceHeuristicFunction
    implements HeuristicFunction {
        private Object goal;
        private Map map;

        public StraightLineDistanceHeuristicFunction(Object goal, Map map) {
            this.goal = goal;
            this.map = map;
        }

        @Override
        public double h(Object state) {
            double result = 0.0;
            Point2D pt1 = this.map.getPosition((String)state);
            Point2D pt2 = this.map.getPosition((String)this.goal);
            if (pt1 != null && pt2 != null) {
                result = pt1.distance(pt2);
            }
            return result;
        }
    }

    private static class MapPerceptToStateFunction
    implements PerceptToStateFunction {
        private MapPerceptToStateFunction() {
        }

        @Override
        public Object getState(Percept p) {
            return ((DynamicPercept)p).getAttribute("in");
        }
    }

    private static class MapResultFunction
    implements ResultFunction {
        @Override
        public Object result(Object s, Action a) {
            if (a instanceof MoveToAction) {
                MoveToAction mta = (MoveToAction)a;
                return mta.getToLocation();
            }
            return s;
        }
    }

    private static class MapActionsFunction
    implements ActionsFunction {
        private Map map = null;
        private boolean reverseMode;

        public MapActionsFunction(Map map, boolean reverseMode) {
            this.map = map;
            this.reverseMode = reverseMode;
        }

        @Override
        public Set<Action> actions(Object state) {
            LinkedHashSet<Action> actions = new LinkedHashSet<Action>();
            String location = state.toString();
            List<String> linkedLocations = this.reverseMode ? this.map.getPossiblePrevLocations(location) : this.map.getPossibleNextLocations(location);
            for (String linkLoc : linkedLocations) {
                actions.add(new MoveToAction(linkLoc));
            }
            return actions;
        }
    }
}

