/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.map;

import aima.core.agent.Action;
import aima.core.agent.Agent;
import aima.core.agent.Percept;
import aima.core.agent.impl.AbstractEnvironment;
import aima.core.agent.impl.DynamicPercept;
import aima.core.environment.map.Map;
import aima.core.environment.map.MapEnvironmentState;
import aima.core.environment.map.MoveToAction;

public class MapEnvironment
extends AbstractEnvironment {
    private Map map = null;
    private MapEnvironmentState state = new MapEnvironmentState();

    public MapEnvironment(Map map) {
        this.map = map;
    }

    public void addAgent(Agent a, String startLocation) {
        this.state.setAgentLocationAndTravelDistance(a, startLocation, 0.0);
        super.addAgent(a);
    }

    public String getAgentLocation(Agent a) {
        return this.state.getAgentLocation(a);
    }

    public Double getAgentTravelDistance(Agent a) {
        return this.state.getAgentTravelDistance(a);
    }

    @Override
    public void executeAction(Agent agent, Action a) {
        if (!a.isNoOp()) {
            MoveToAction act = (MoveToAction)a;
            String currLoc = this.getAgentLocation(agent);
            Double distance = this.map.getDistance(currLoc, act.getToLocation());
            if (distance != null) {
                double currTD = this.getAgentTravelDistance(agent);
                this.state.setAgentLocationAndTravelDistance(agent, act.getToLocation(), currTD + distance);
            }
        }
    }

    @Override
    public Percept getPerceptSeenBy(Agent anAgent) {
        return new DynamicPercept("in", this.getAgentLocation(anAgent));
    }

    public Map getMap() {
        return this.map;
    }
}

