/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.map;

import aima.core.agent.Action;
import aima.core.agent.EnvironmentViewNotifier;
import aima.core.agent.Percept;
import aima.core.agent.State;
import aima.core.agent.impl.DynamicPercept;
import aima.core.agent.impl.DynamicState;
import aima.core.environment.map.BidirectionalMapProblem;
import aima.core.environment.map.Map;
import aima.core.search.framework.ProblemSolvingAgent;
import aima.core.search.framework.SearchForActions;
import aima.core.search.framework.evalfunc.EvaluationFunction;
import aima.core.search.framework.evalfunc.HeuristicFunctionFactory;
import aima.core.search.framework.problem.Problem;
import aima.core.search.informed.BestFirstSearch;
import aima.core.search.informed.HeuristicEvaluationFunction;
import aima.core.search.informed.RecursiveBestFirstSearch;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MapAgent
extends ProblemSolvingAgent {
    protected final Map map;
    protected final DynamicState state = new DynamicState();
    protected final List<String> goals = new ArrayList<String>();
    protected int currGoalIdx = -1;
    protected EnvironmentViewNotifier notifier = null;
    private SearchForActions search = null;
    private HeuristicFunctionFactory hfFactory;

    public MapAgent(Map map, SearchForActions search, String goal) {
        this.map = map;
        this.search = search;
        this.goals.add(goal);
    }

    public MapAgent(Map map, SearchForActions search, String goal, EnvironmentViewNotifier notifier) {
        this(map, search, goal);
        this.notifier = notifier;
    }

    public MapAgent(Map map, SearchForActions search, List<String> goals) {
        this.map = map;
        this.search = search;
        this.goals.addAll(goals);
    }

    public MapAgent(Map map, SearchForActions search, List<String> goals, EnvironmentViewNotifier notifier) {
        this(map, search, goals);
        this.notifier = notifier;
    }

    public MapAgent(Map map, SearchForActions search, List<String> goals, EnvironmentViewNotifier notifier, HeuristicFunctionFactory hfFactory) {
        this(map, search, goals, notifier);
        this.hfFactory = hfFactory;
    }

    @Override
    protected State updateState(Percept p) {
        DynamicPercept dp = (DynamicPercept)p;
        this.state.setAttribute("location", dp.getAttribute("in"));
        return this.state;
    }

    @Override
    protected Object formulateGoal() {
        String goal = null;
        if (this.currGoalIdx < this.goals.size() - 1) {
            goal = this.goals.get(++this.currGoalIdx);
            if (this.notifier != null) {
                this.notifier.notifyViews("CurrentLocation=In(" + this.state.getAttribute("location") + "), Goal=In(" + goal + ")");
            }
            this.modifyHeuristicFunction(goal);
        }
        return goal;
    }

    @Override
    protected Problem formulateProblem(Object goal) {
        return new BidirectionalMapProblem(this.map, (String)this.state.getAttribute("location"), (String)goal);
    }

    @Override
    protected List<Action> search(Problem problem) {
        ArrayList<Action> result = new ArrayList<Action>();
        try {
            result.addAll(this.search.findActions(problem));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.notifyViewOfMetrics();
        return result;
    }

    protected void notifyViewOfMetrics() {
        if (this.notifier != null) {
            Set<String> keys = this.search.getMetrics().keySet();
            for (String key : keys) {
                this.notifier.notifyViews("METRIC[" + key + "]=" + this.search.getMetrics().get(key));
            }
        }
    }

    private void modifyHeuristicFunction(Object goal) {
        if (this.hfFactory != null) {
            EvaluationFunction ef = null;
            if (this.search instanceof BestFirstSearch) {
                ef = ((BestFirstSearch)this.search).getEvaluationFunction();
            } else if (this.search instanceof RecursiveBestFirstSearch) {
                ef = ((RecursiveBestFirstSearch)this.search).getEvaluationFunction();
            }
            if (ef instanceof HeuristicEvaluationFunction) {
                ((HeuristicEvaluationFunction)ef).setHeuristicFunction(this.hfFactory.createHeuristicFunction(goal));
            }
        }
    }
}

