/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.eightpuzzle;

import aima.core.agent.Action;
import aima.core.environment.eightpuzzle.EightPuzzleBoard;
import aima.core.search.framework.problem.ActionsFunction;
import aima.core.search.framework.problem.ResultFunction;
import java.util.LinkedHashSet;
import java.util.Set;

public class EightPuzzleFunctionFactory {
    private static ActionsFunction _actionsFunction = null;
    private static ResultFunction _resultFunction = null;

    public static ActionsFunction getActionsFunction() {
        if (null == _actionsFunction) {
            _actionsFunction = new EPActionsFunction();
        }
        return _actionsFunction;
    }

    public static ResultFunction getResultFunction() {
        if (null == _resultFunction) {
            _resultFunction = new EPResultFunction();
        }
        return _resultFunction;
    }

    private static class EPResultFunction
    implements ResultFunction {
        private EPResultFunction() {
        }

        @Override
        public Object result(Object s, Action a) {
            EightPuzzleBoard board = (EightPuzzleBoard)s;
            if (EightPuzzleBoard.UP.equals(a) && board.canMoveGap(EightPuzzleBoard.UP)) {
                EightPuzzleBoard newBoard = new EightPuzzleBoard(board);
                newBoard.moveGapUp();
                return newBoard;
            }
            if (EightPuzzleBoard.DOWN.equals(a) && board.canMoveGap(EightPuzzleBoard.DOWN)) {
                EightPuzzleBoard newBoard = new EightPuzzleBoard(board);
                newBoard.moveGapDown();
                return newBoard;
            }
            if (EightPuzzleBoard.LEFT.equals(a) && board.canMoveGap(EightPuzzleBoard.LEFT)) {
                EightPuzzleBoard newBoard = new EightPuzzleBoard(board);
                newBoard.moveGapLeft();
                return newBoard;
            }
            if (EightPuzzleBoard.RIGHT.equals(a) && board.canMoveGap(EightPuzzleBoard.RIGHT)) {
                EightPuzzleBoard newBoard = new EightPuzzleBoard(board);
                newBoard.moveGapRight();
                return newBoard;
            }
            return s;
        }
    }

    private static class EPActionsFunction
    implements ActionsFunction {
        private EPActionsFunction() {
        }

        @Override
        public Set<Action> actions(Object state) {
            EightPuzzleBoard board = (EightPuzzleBoard)state;
            LinkedHashSet<Action> actions = new LinkedHashSet<Action>();
            if (board.canMoveGap(EightPuzzleBoard.UP)) {
                actions.add(EightPuzzleBoard.UP);
            }
            if (board.canMoveGap(EightPuzzleBoard.DOWN)) {
                actions.add(EightPuzzleBoard.DOWN);
            }
            if (board.canMoveGap(EightPuzzleBoard.LEFT)) {
                actions.add(EightPuzzleBoard.LEFT);
            }
            if (board.canMoveGap(EightPuzzleBoard.RIGHT)) {
                actions.add(EightPuzzleBoard.RIGHT);
            }
            return actions;
        }
    }
}

