/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.eightpuzzle;

import aima.core.agent.Action;
import aima.core.agent.impl.DynamicAction;
import aima.core.util.datastructure.XYLocation;
import java.util.ArrayList;
import java.util.List;

public class EightPuzzleBoard {
    public static Action LEFT = new DynamicAction("Left");
    public static Action RIGHT = new DynamicAction("Right");
    public static Action UP = new DynamicAction("Up");
    public static Action DOWN = new DynamicAction("Down");
    private int[] state;

    public EightPuzzleBoard() {
        this.state = new int[]{5, 4, 0, 6, 1, 8, 7, 3, 2};
    }

    public EightPuzzleBoard(int[] state) {
        this.state = new int[state.length];
        System.arraycopy(state, 0, this.state, 0, state.length);
    }

    public EightPuzzleBoard(EightPuzzleBoard copyBoard) {
        this(copyBoard.getState());
    }

    public int[] getState() {
        return this.state;
    }

    public int getValueAt(XYLocation loc) {
        return this.getValueAt(loc.getXCoOrdinate(), loc.getYCoOrdinate());
    }

    public XYLocation getLocationOf(int val) {
        int absPos = this.getPositionOf(val);
        return new XYLocation(this.getXCoord(absPos), this.getYCoord(absPos));
    }

    public void moveGapRight() {
        int gapPos = this.getGapPosition();
        int x = this.getXCoord(gapPos);
        int ypos = this.getYCoord(gapPos);
        if (ypos != 2) {
            int valueOnRight = this.getValueAt(x, ypos + 1);
            this.setValue(x, ypos, valueOnRight);
            this.setValue(x, ypos + 1, 0);
        }
    }

    public void moveGapLeft() {
        int gapPos = this.getGapPosition();
        int x = this.getXCoord(gapPos);
        int ypos = this.getYCoord(gapPos);
        if (ypos != 0) {
            int valueOnLeft = this.getValueAt(x, ypos - 1);
            this.setValue(x, ypos, valueOnLeft);
            this.setValue(x, ypos - 1, 0);
        }
    }

    public void moveGapDown() {
        int gapPos = this.getGapPosition();
        int x = this.getXCoord(gapPos);
        int y = this.getYCoord(gapPos);
        if (x != 2) {
            int valueOnBottom = this.getValueAt(x + 1, y);
            this.setValue(x, y, valueOnBottom);
            this.setValue(x + 1, y, 0);
        }
    }

    public void moveGapUp() {
        int gapPos = this.getGapPosition();
        int x = this.getXCoord(gapPos);
        int y = this.getYCoord(gapPos);
        if (x != 0) {
            int valueOnTop = this.getValueAt(x - 1, y);
            this.setValue(x, y, valueOnTop);
            this.setValue(x - 1, y, 0);
        }
    }

    public List<XYLocation> getPositions() {
        ArrayList<XYLocation> retVal = new ArrayList<XYLocation>();
        for (int i = 0; i < 9; ++i) {
            int absPos = this.getPositionOf(i);
            XYLocation loc = new XYLocation(this.getXCoord(absPos), this.getYCoord(absPos));
            retVal.add(loc);
        }
        return retVal;
    }

    public void setBoard(List<XYLocation> locs) {
        int count = 0;
        for (int i = 0; i < locs.size(); ++i) {
            XYLocation loc = locs.get(i);
            this.setValue(loc.getXCoOrdinate(), loc.getYCoOrdinate(), count);
            ++count;
        }
    }

    public boolean canMoveGap(Action where) {
        boolean retVal = true;
        int absPos = this.getPositionOf(0);
        if (where.equals(LEFT)) {
            retVal = this.getYCoord(absPos) != 0;
        } else if (where.equals(RIGHT)) {
            retVal = this.getYCoord(absPos) != 2;
        } else if (where.equals(UP)) {
            retVal = this.getXCoord(absPos) != 0;
        } else if (where.equals(DOWN)) {
            retVal = this.getXCoord(absPos) != 2;
        }
        return retVal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EightPuzzleBoard aBoard = (EightPuzzleBoard)o;
        for (int i = 0; i < 8; ++i) {
            if (this.getPositionOf(i) == aBoard.getPositionOf(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        for (int i = 0; i < 8; ++i) {
            int position = this.getPositionOf(i);
            result = 37 * result + position;
        }
        return result;
    }

    public String toString() {
        String retVal = this.state[0] + " " + this.state[1] + " " + this.state[2] + "\n" + this.state[3] + " " + this.state[4] + " " + this.state[5] + " \n" + this.state[6] + " " + this.state[7] + " " + this.state[8];
        return retVal;
    }

    private int getXCoord(int absPos) {
        return absPos / 3;
    }

    private int getYCoord(int absPos) {
        return absPos % 3;
    }

    private int getAbsPosition(int x, int y) {
        return x * 3 + y;
    }

    private int getValueAt(int x, int y) {
        return this.state[this.getAbsPosition(x, y)];
    }

    private int getGapPosition() {
        return this.getPositionOf(0);
    }

    private int getPositionOf(int val) {
        for (int i = 0; i < 9; ++i) {
            if (this.state[i] != val) continue;
            return i;
        }
        return -1;
    }

    private void setValue(int x, int y, int val) {
        int absPos = this.getAbsPosition(x, y);
        this.state[absPos] = val;
    }
}

