/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.connectfour;

public class ConnectFourState
implements Cloneable {
    private int cols;
    private byte[] board;
    private int moveCount;
    private double utility = -1.0;
    public int winPositions1;
    public int winPositions2;

    public ConnectFourState(int rows, int cols) {
        this.cols = cols;
        this.board = new byte[rows * cols];
    }

    public int getRows() {
        return this.board.length / this.cols;
    }

    public int getCols() {
        return this.cols;
    }

    public double getUtility() {
        return this.utility;
    }

    public int getPlayerNum(int row, int col) {
        return this.board[row * this.cols + col] & 3;
    }

    public int getPlayerToMove() {
        return this.moveCount % 2 + 1;
    }

    public int getMoves() {
        return this.moveCount;
    }

    public void dropDisk(int col) {
        int playerNum = this.getPlayerToMove();
        int row = this.getFreeRow(col);
        if (row != -1) {
            ++this.moveCount;
            if (this.moveCount == this.board.length) {
                this.utility = 0.5;
            }
            if (this.isWinPositionFor(row, col, 1)) {
                --this.winPositions1;
                if (playerNum == 1) {
                    this.utility = 1.0;
                }
            }
            if (this.isWinPositionFor(row, col, 2)) {
                --this.winPositions2;
                if (playerNum == 2) {
                    this.utility = 0.0;
                }
            }
            this.board[row * this.cols + col] = (byte)playerNum;
            if (this.utility == -1.0) {
                this.analyzeWinPositions(row, col);
            }
        }
    }

    private int getFreeRow(int col) {
        for (int row = this.getRows() - 1; row >= 0; --row) {
            if (this.getPlayerNum(row, col) != 0) continue;
            return row;
        }
        return -1;
    }

    public boolean isWinMoveFor(int col, int playerNum) {
        return this.isWinPositionFor(this.getFreeRow(col), col, playerNum);
    }

    public boolean isWinPositionFor(int row, int col, int playerNum) {
        return (this.board[row * this.cols + col] & playerNum * 4) > 0;
    }

    private void setWinPositionFor(int row, int col, int playerNum) {
        if (playerNum == 1) {
            if (!this.isWinPositionFor(row, col, 1)) {
                ++this.winPositions1;
            }
        } else if (playerNum == 2) {
            if (!this.isWinPositionFor(row, col, 2)) {
                ++this.winPositions2;
            }
        } else {
            throw new IllegalArgumentException("Wrong player number.");
        }
        int n = row * this.cols + col;
        this.board[n] = (byte)(this.board[n] | playerNum * 4);
    }

    private void analyzeWinPositions(int moveRow, int moveCol) {
        int[] rowIncr = new int[]{1, 0, 1, 1};
        int[] colIncr = new int[]{0, 1, -1, 1};
        int playerNum = this.getPlayerNum(moveRow, moveCol);
        WinPositionInfo[] wInfo = new WinPositionInfo[]{new WinPositionInfo(), new WinPositionInfo()};
        for (int i = 0; i < 4; ++i) {
            WinPositionInfo wInf;
            int j;
            int rIncr = rowIncr[i];
            int cIncr = colIncr[i];
            int diskCount = 1;
            for (j = 0; j < 2; ++j) {
                wInf = wInfo[j];
                wInf.clear();
                int rBound = rIncr > 0 ? this.getRows() : -1;
                int cBound = cIncr > 0 ? this.getCols() : -1;
                int row = moveRow + rIncr;
                for (int col = moveCol + cIncr; row != rBound && col != cBound; row += rIncr, col += cIncr) {
                    int plNum = this.getPlayerNum(row, col);
                    if (plNum == playerNum) {
                        if (wInf.hasData()) {
                            ++wInf.diskCount;
                            continue;
                        }
                        ++diskCount;
                        continue;
                    }
                    if (plNum != 0 || wInf.hasData()) break;
                    wInf.row = row;
                    wInf.col = col;
                }
                rIncr = -rIncr;
                cIncr = -cIncr;
            }
            for (j = 0; j < 2; ++j) {
                wInf = wInfo[j];
                if (!wInf.hasData() || diskCount + wInf.diskCount < 3) continue;
                this.setWinPositionFor(wInf.row, wInf.col, playerNum);
            }
        }
    }

    public int analyzePotentialWinPositions(Integer action) {
        int[] rowIncr = new int[]{1, 0, 1, 1};
        int[] colIncr = new int[]{0, 1, -1, 1};
        int moveCol = action;
        int moveRow = this.getFreeRow(moveCol);
        int playerNum = this.getPlayerToMove();
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            int rIncr = rowIncr[i];
            int cIncr = colIncr[i];
            int posCountSum = 0;
            for (int j = 0; j < 2; ++j) {
                int plNum;
                int rBound = rIncr > 0 ? this.getRows() : -1;
                int cBound = cIncr > 0 ? this.getCols() : -1;
                int posCount = 0;
                int row = moveRow + rIncr;
                for (int col = moveCol + cIncr; row != rBound && col != cBound && posCount < 3 && (plNum = this.getPlayerNum(row, col)) != 3 - playerNum; ++posCount, row += rIncr, col += cIncr) {
                }
                posCountSum += posCount;
                rIncr = -rIncr;
                cIncr = -cIncr;
            }
            if (posCountSum < 3) continue;
            result += posCountSum;
        }
        return result;
    }

    public ConnectFourState clone() {
        ConnectFourState result = null;
        try {
            result = (ConnectFourState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        result.board = (byte[])this.board.clone();
        return result;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.board.length; ++i) {
            result = result * 7 + this.board[i] + 1;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectFourState) {
            ConnectFourState s = (ConnectFourState)obj;
            for (int i = 0; i < this.board.length; ++i) {
                if (this.board[i] == s.board[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static class WinPositionInfo {
        int row = -1;
        int col = -1;
        int diskCount;

        WinPositionInfo() {
        }

        void clear() {
            this.row = -1;
            this.col = -1;
            this.diskCount = 0;
        }

        boolean hasData() {
            return this.row != -1;
        }
    }
}

