/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.connectfour;

import aima.core.environment.connectfour.ConnectFourState;
import aima.core.search.adversarial.Game;
import java.util.ArrayList;
import java.util.List;

public class ConnectFourGame
implements Game<ConnectFourState, Integer, String> {
    String[] players = new String[]{"red", "yellow"};
    ConnectFourState initialState = new ConnectFourState(6, 7);

    @Override
    public ConnectFourState getInitialState() {
        return this.initialState;
    }

    public String[] getPlayers() {
        return this.players;
    }

    @Override
    public String getPlayer(ConnectFourState state) {
        return this.getPlayer(state.getPlayerToMove());
    }

    @Override
    public String getPlayer(int playerNum) {
        switch (playerNum) {
            case 1: {
                return this.players[0];
            }
            case 2: {
                return this.players[1];
            }
        }
        return null;
    }

    public int getPlayerNum(String player) {
        for (int i = 0; i < this.players.length; ++i) {
            if (this.players[i] != player) continue;
            return i + 1;
        }
        throw new IllegalArgumentException("Wrong player number.");
    }

    @Override
    public List<Integer> getActions(ConnectFourState state) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < state.getCols(); ++i) {
            if (state.getPlayerNum(0, i) != 0) continue;
            result.add(i);
        }
        return result;
    }

    @Override
    public ConnectFourState getResult(ConnectFourState state, Integer action) {
        ConnectFourState result = state.clone();
        result.dropDisk(action);
        return result;
    }

    @Override
    public boolean isTerminal(ConnectFourState state) {
        return state.getUtility() != -1.0;
    }

    @Override
    public double getUtility(ConnectFourState state, String player) {
        double result = state.getUtility();
        if (result != -1.0) {
            if (player == this.players[1]) {
                result = 1.0 - result;
            }
        } else {
            throw new IllegalArgumentException("State is not terminal.");
        }
        return result;
    }
}

