/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.connectfour;

import aima.core.environment.connectfour.ActionValuePair;
import aima.core.environment.connectfour.ConnectFourState;
import aima.core.search.adversarial.Game;
import aima.core.search.adversarial.IterativeDeepeningAlphaBetaSearch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConnectFourAIPlayer
extends IterativeDeepeningAlphaBetaSearch<ConnectFourState, Integer, String> {
    public ConnectFourAIPlayer(Game<ConnectFourState, Integer, String> game, int time) {
        super(game, 0.0, 1.0, time);
    }

    @Override
    protected boolean isSignificantlyBetter(double newUtility, double utility) {
        return newUtility - utility > (this.utilMax - this.utilMin) * 0.4;
    }

    @Override
    protected boolean hasSafeWinner(double resultUtility) {
        return Math.abs(resultUtility - (this.utilMin + this.utilMax) / 2.0) > 0.4 * this.utilMax - this.utilMin;
    }

    @Override
    protected double eval(ConnectFourState state, String player) {
        double value = super.eval(state, player);
        if (this.hasSafeWinner(value)) {
            value = value > (this.utilMin + this.utilMax) / 2.0 ? (value -= (double)state.getMoves() / 1000.0) : (value += (double)state.getMoves() / 1000.0);
        }
        return value;
    }

    @Override
    public List<Integer> orderActions(ConnectFourState state, List<Integer> actions, String player, int depth) {
        List<Integer> result = actions;
        if (depth == 0) {
            ArrayList<ActionValuePair<Integer>> actionEstimates = new ArrayList<ActionValuePair<Integer>>(actions.size());
            for (Integer n : actions) {
                actionEstimates.add(ActionValuePair.createFor(n, state.analyzePotentialWinPositions(n)));
            }
            Collections.sort(actionEstimates);
            result = new ArrayList<Integer>();
            for (ActionValuePair actionValuePair : actionEstimates) {
                result.add((Integer)actionValuePair.getAction());
            }
        }
        return result;
    }
}

