/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.cellworld;

import aima.core.agent.Action;
import java.util.LinkedHashSet;
import java.util.Set;

public enum CellWorldAction implements Action
{
    Up,
    Down,
    Left,
    Right,
    None;

    private static final Set<CellWorldAction> _actions;

    public static final Set<CellWorldAction> actions() {
        return _actions;
    }

    @Override
    public boolean isNoOp() {
        return None == this;
    }

    public int getXResult(int curX) {
        int newX = curX;
        switch (this) {
            case Left: {
                --newX;
                break;
            }
            case Right: {
                ++newX;
                break;
            }
        }
        return newX;
    }

    public int getYResult(int curY) {
        int newY = curY;
        switch (this) {
            case Up: {
                ++newY;
                break;
            }
            case Down: {
                --newY;
                break;
            }
        }
        return newY;
    }

    public CellWorldAction getFirstRightAngledAction() {
        CellWorldAction a = null;
        switch (this) {
            case Up: 
            case Down: {
                a = Left;
                break;
            }
            case Left: 
            case Right: {
                a = Down;
                break;
            }
            case None: {
                a = None;
            }
        }
        return a;
    }

    public CellWorldAction getSecondRightAngledAction() {
        CellWorldAction a = null;
        switch (this) {
            case Up: 
            case Down: {
                a = Right;
                break;
            }
            case Left: 
            case Right: {
                a = Up;
                break;
            }
            case None: {
                a = None;
            }
        }
        return a;
    }

    static {
        _actions = new LinkedHashSet<CellWorldAction>();
        _actions.add(Up);
        _actions.add(Down);
        _actions.add(Left);
        _actions.add(Right);
        _actions.add(None);
    }
}

