/*
 * Decompiled with CFR 0.152.
 */
package aima.core.environment.cellworld;

import aima.core.environment.cellworld.Cell;
import aima.core.environment.cellworld.CellWorldAction;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class CellWorld<C> {
    private Set<Cell<C>> cells = new LinkedHashSet<Cell<C>>();
    private Map<Integer, Map<Integer, Cell<C>>> cellLookup = new HashMap<Integer, Map<Integer, Cell<C>>>();

    public CellWorld(int xDimension, int yDimension, C defaultCellContent) {
        for (int x = 1; x <= xDimension; ++x) {
            HashMap<Integer, Cell<C>> xCol = new HashMap<Integer, Cell<C>>();
            for (int y = 1; y <= yDimension; ++y) {
                Cell<C> c = new Cell<C>(x, y, defaultCellContent);
                this.cells.add(c);
                xCol.put(y, c);
            }
            this.cellLookup.put(x, xCol);
        }
    }

    public Set<Cell<C>> getCells() {
        return this.cells;
    }

    public Cell<C> result(Cell<C> s, CellWorldAction a) {
        Cell<C> sDelta = this.getCellAt(a.getXResult(s.getX()), a.getYResult(s.getY()));
        if (null == sDelta) {
            sDelta = s;
        }
        return sDelta;
    }

    public void removeCell(int x, int y) {
        Map<Integer, Cell<C>> xCol = this.cellLookup.get(x);
        if (null != xCol) {
            this.cells.remove(xCol.remove(y));
        }
    }

    public Cell<C> getCellAt(int x, int y) {
        Cell<C> c = null;
        Map<Integer, Cell<C>> xCol = this.cellLookup.get(x);
        if (null != xCol) {
            c = xCol.get(y);
        }
        return c;
    }
}

